/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.abfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.BoundDTExtension;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.apache.hadoop.io.IOUtils;
import org.apache.knox.gateway.cloud.idbroker.abfs.AbfsIDBIntegration;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsIDBCredentialProvider
implements CustomTokenProviderAdaptee,
BoundDTExtension {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsIDBCredentialProvider.class);
    private AbfsIDBIntegration integration;

    public void initialize(Configuration conf, String account) throws IOException {
    }

    public void bind(URI uri, Configuration conf) throws IOException {
        LOG.debug("Binding to URI {}", (Object)uri);
        this.setIntegration(AbfsIDBIntegration.fromAbfsCredentialProvider(uri, conf));
    }

    private void checkBound() {
        Preconditions.checkState(this.integration != null, "Credential Provider is not bound");
    }

    public void close() {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.integration});
        this.integration = null;
    }

    public String getAccessToken() throws IOException {
        this.checkBound();
        AzureADToken token = this.integration.getADToken(true);
        Preconditions.checkNotNull(token, "Azure access token is not available");
        String accessToken = token.getAccessToken();
        Preconditions.checkNotNull(accessToken, "Azure access token value is not available");
        return accessToken;
    }

    public Date getExpiryTime() {
        this.checkBound();
        AzureADToken token = null;
        try {
            token = this.integration.getADToken(false);
            Preconditions.checkNotNull(token, "Azure access token is not available");
        }
        catch (IOException e) {
            Preconditions.checkNotNull(token, "Azure access token is not available: " + e.toString());
        }
        Date expiry = token.getExpiry();
        Preconditions.checkNotNull(expiry, "Azure access token expiry is not available");
        return expiry;
    }

    public String getCanonicalServiceName() {
        this.checkBound();
        return this.integration.getCanonicalServiceName();
    }

    public String getUserAgentSuffix() {
        this.checkBound();
        return this.integration.getUserAgentSuffix();
    }

    protected void setIntegration(AbfsIDBIntegration integration) {
        this.integration = integration;
    }
}

