/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput.impl;

import org.apache.jena.irix.IRIx;
import org.apache.jena.rdfxml.xmlinput.ARPErrorNumbers;
import org.apache.jena.rdfxml.xmlinput.impl.AbsXMLContext;
import org.apache.jena.rdfxml.xmlinput.impl.Taint;
import org.apache.jena.rdfxml.xmlinput.impl.TaintImpl;
import org.apache.jena.rdfxml.xmlinput.impl.XMLHandler;
import org.xml.sax.SAXParseException;

public class XMLContext
extends AbsXMLContext
implements ARPErrorNumbers {
    XMLContext(XMLHandler h, String base) throws SAXParseException {
        this(h, h.iriProvider().create(base));
    }

    protected XMLContext(XMLHandler h, IRIx uri, Taint baseT) {
        super(!h.ignoring(3), null, uri, baseT, "", new TaintImpl());
    }

    private XMLContext(XMLHandler h, IRIx baseMaybeWithFrag) throws SAXParseException {
        this(h, baseMaybeWithFrag.resolve(""), baseMaybeWithFrag);
    }

    private XMLContext(XMLHandler h, IRIx base, IRIx baseMaybeWithFrag) throws SAXParseException {
        this(h, base, XMLContext.initTaint(h, baseMaybeWithFrag));
    }

    XMLContext(boolean b, AbsXMLContext document, IRIx uri, Taint baseT, String lang, Taint langT) {
        super(b, document, uri, baseT, lang, langT);
    }

    @Override
    boolean keepDocument(XMLHandler forErrors) {
        return true;
    }

    boolean isSameAsDocument() {
        return this == this.document || (this.uri == null ? this.document.uri == null : this.uri.equals(this.document.uri));
    }

    @Override
    AbsXMLContext clone(IRIx u, Taint baseT, String lng, Taint langT) {
        return new XMLContext(true, this.document, u, baseT, lng, langT);
    }

    void baseUsed(XMLHandler forErrors, Taint taintMe, String relUri, String resolvedURI) throws SAXParseException {
        String other;
        if (this.document == null || relUri.equals(resolvedURI)) {
            return;
        }
        if (!this.isSameAsDocument() && !(other = this.document.uri.resolve(relUri).toString()).equals(resolvedURI)) {
            forErrors.warning(taintMe, 3, "Use of attribute xml:base changes interpretation of relative URI: \"" + relUri + "\".");
        }
    }

    @Override
    void checkBaseUse(XMLHandler forErrors, Taint taintMe, String relUri, IRIx rslt) throws SAXParseException {
        String other;
        if (this.document == null) {
            return;
        }
        String resolvedURI = rslt.toString();
        if (relUri.equals(resolvedURI)) {
            return;
        }
        if (!this.isSameAsDocument() && !(other = this.document.uri.resolve(relUri).toString()).equals(resolvedURI)) {
            forErrors.warning(taintMe, 3, "Use of attribute xml:base changes interpretation of relative URI: \"" + relUri + "\".");
        }
    }
}

