/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.yarn.server.resourcemanager.scheduler.fair;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.impala.yarn.server.utils.BuilderUtils;

public class FairSchedulerConfiguration
extends Configuration {
    private static final String CONF_PREFIX = "yarn.scheduler.fair.";
    public static final String ALLOCATION_FILE = "yarn.scheduler.fair.allocation.file";
    protected static final String DEFAULT_ALLOCATION_FILE = "fair-scheduler.xml";
    protected static final String ALLOW_UNDECLARED_POOLS = "yarn.scheduler.fair.allow-undeclared-pools";
    protected static final boolean DEFAULT_ALLOW_UNDECLARED_POOLS = true;
    protected static final String USER_AS_DEFAULT_QUEUE = "yarn.scheduler.fair.user-as-default-queue";
    protected static final boolean DEFAULT_USER_AS_DEFAULT_QUEUE = true;

    public static Resource parseResourceConfigValue(String val) throws AllocationConfigurationException {
        try {
            val = val.toLowerCase();
            int memory = FairSchedulerConfiguration.findResource(val, "mb");
            int vcores = FairSchedulerConfiguration.findResource(val, "vcores");
            return BuilderUtils.newResource(memory, vcores);
        }
        catch (AllocationConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AllocationConfigurationException("Error reading resource config", ex);
        }
    }

    private static int findResource(String val, String units) throws AllocationConfigurationException {
        Pattern pattern = Pattern.compile("(\\d+)(\\.\\d*)?\\s*" + units);
        Matcher matcher = pattern.matcher(val);
        if (!matcher.find()) {
            throw new AllocationConfigurationException("Missing resource: " + units);
        }
        return Integer.parseInt(matcher.group(1));
    }
}

