/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.impala.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AllocationFileLoaderService
extends AbstractService {
    public static final Logger LOG = LoggerFactory.getLogger(AllocationFileLoaderService.class);
    public static final long ALLOC_RELOAD_INTERVAL_MS = 10000L;
    public static final long ALLOC_RELOAD_WAIT_MS = 5000L;
    public static final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    public static final String ROOT_POOL_NAME = "root";
    private final Clock clock;
    private long lastSuccessfulReload;
    private boolean lastReloadAttemptFailed = false;
    private File allocFile;
    private Listener reloadListener;
    @VisibleForTesting
    long reloadIntervalMs = 10000L;
    private Thread reloadThread;
    private volatile boolean running = true;

    public AllocationFileLoaderService() {
        this((Clock)new SystemClock());
    }

    public AllocationFileLoaderService(Clock clock) {
        super(AllocationFileLoaderService.class.getName());
        this.clock = clock;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.allocFile = this.getAllocationFile(conf);
        if (this.allocFile != null) {
            this.reloadThread = new Thread(){

                @Override
                public void run() {
                    while (AllocationFileLoaderService.this.running) {
                        long time = AllocationFileLoaderService.this.clock.getTime();
                        long lastModified = AllocationFileLoaderService.this.allocFile.lastModified();
                        if (lastModified > AllocationFileLoaderService.this.lastSuccessfulReload && time > lastModified + 5000L) {
                            try {
                                AllocationFileLoaderService.this.reloadAllocations();
                            }
                            catch (Exception ex) {
                                if (!AllocationFileLoaderService.this.lastReloadAttemptFailed) {
                                    LOG.error("Failed to reload fair scheduler config file - will use existing allocations.", (Throwable)ex);
                                }
                                AllocationFileLoaderService.this.lastReloadAttemptFailed = true;
                            }
                        } else if (lastModified == 0L) {
                            if (!AllocationFileLoaderService.this.lastReloadAttemptFailed) {
                                LOG.warn("Failed to reload fair scheduler config file because last modified returned 0. File exists: " + AllocationFileLoaderService.this.allocFile.exists());
                            }
                            AllocationFileLoaderService.this.lastReloadAttemptFailed = true;
                        }
                        try {
                            Thread.sleep(AllocationFileLoaderService.this.reloadIntervalMs);
                        }
                        catch (InterruptedException ex) {
                            LOG.info("Interrupted while waiting to reload alloc configuration");
                        }
                    }
                }
            };
            this.reloadThread.setName("AllocationFileReloader");
            this.reloadThread.setDaemon(true);
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        if (this.reloadThread != null) {
            this.reloadThread.start();
        }
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.running = false;
        if (this.reloadThread != null) {
            this.reloadThread.interrupt();
            try {
                this.reloadThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("reloadThread fails to join.");
            }
        }
        super.serviceStop();
    }

    public File getAllocationFile(Configuration conf) {
        String allocFilePath = conf.get("yarn.scheduler.fair.allocation.file", "fair-scheduler.xml");
        File allocFile = new File(allocFilePath);
        if (!allocFile.isAbsolute()) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(allocFilePath);
            if (url == null) {
                LOG.warn(allocFilePath + " not found on the classpath.");
                allocFile = null;
            } else {
                if (!url.getProtocol().equalsIgnoreCase("file")) {
                    throw new RuntimeException("Allocation file " + url + " found on the classpath is not on the local filesystem.");
                }
                allocFile = new File(url.getPath());
            }
        }
        return allocFile;
    }

    public synchronized void setReloadListener(Listener reloadListener) {
        this.reloadListener = reloadListener;
    }

    @VisibleForTesting
    public static void addQueryLimits(String queueName, Element element, String parentName, Map<String, Map<String, Integer>> limitsMap, String tagName) throws AllocationConfigurationException {
        Map limits = limitsMap.computeIfAbsent(queueName, k -> new HashMap());
        int number = -1;
        ArrayList<String> nameList = new ArrayList<String>();
        NodeList fields = element.getChildNodes();
        for (int j = 0; j < fields.getLength(); ++j) {
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if (tagName.equals(field.getTagName())) {
                String name = ((Text)field.getFirstChild()).getData().trim();
                if (nameList.contains(name)) {
                    throw new AllocationConfigurationException("Duplicate value given for name " + name);
                }
                nameList.add(name);
            } else if ("totalCount".equals(field.getTagName())) {
                String numberStr = ((Text)field.getFirstChild()).getData().trim();
                if (number != -1) {
                    throw new AllocationConfigurationException("Duplicate totalCount tags for " + parentName + "/" + field.getTagName());
                }
                try {
                    number = Integer.parseInt(numberStr);
                }
                catch (NumberFormatException e) {
                    throw new AllocationConfigurationException("Could not parse query totalCount for " + parentName + "/" + field.getTagName(), e);
                }
            }
            if (!nameList.isEmpty()) continue;
            throw new AllocationConfigurationException("Empty user names for " + parentName);
        }
        if (number == -1) {
            throw new AllocationConfigurationException("No totalCount for " + parentName);
        }
        for (String name : nameList) {
            Integer oldVal = limits.put(name, number);
            if (oldVal == null) continue;
            throw new AllocationConfigurationException("Duplicate entry for " + tagName + " '" + name + "' in pool '" + queueName + "' has multiple values " + oldVal + " and " + number);
        }
    }

    public synchronized void reloadAllocations() throws IOException, ParserConfigurationException, SAXException, AllocationConfigurationException {
        if (this.allocFile == null) {
            return;
        }
        LOG.info("Loading allocation file " + this.allocFile);
        HashMap<String, Resource> minQueueResources = new HashMap<String, Resource>();
        HashMap<String, Resource> maxQueueResources = new HashMap<String, Resource>();
        HashMap<String, Resource> maxChildQueueResources = new HashMap<String, Resource>();
        HashMap<String, Integer> queueMaxApps = new HashMap<String, Integer>();
        HashMap<String, Integer> userMaxApps = new HashMap<String, Integer>();
        HashMap<String, Float> queueMaxAMShares = new HashMap<String, Float>();
        HashMap<String, ResourceWeights> queueWeights = new HashMap<String, ResourceWeights>();
        HashMap<String, SchedulingPolicy> queuePolicies = new HashMap<String, SchedulingPolicy>();
        HashMap<String, Long> minSharePreemptionTimeouts = new HashMap<String, Long>();
        HashMap<String, Long> fairSharePreemptionTimeouts = new HashMap<String, Long>();
        HashMap<String, Float> fairSharePreemptionThresholds = new HashMap<String, Float>();
        HashMap<String, Map<QueueACL, AccessControlList>> queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
        HashMap<String, Map<String, Integer>> userQueryLimits = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Map<String, Integer>> groupQueryLimits = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Boolean> onlyCoordinators = new HashMap<String, Boolean>();
        HashSet<String> nonPreemptableQueues = new HashSet<String>();
        int userMaxAppsDefault = Integer.MAX_VALUE;
        int queueMaxAppsDefault = Integer.MAX_VALUE;
        Resource queueMaxResourcesDefault = Resources.unbounded();
        float queueMaxAMShareDefault = 0.5f;
        long defaultFairSharePreemptionTimeout = Long.MAX_VALUE;
        long defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        float defaultFairSharePreemptionThreshold = 0.5f;
        SchedulingPolicy defaultSchedPolicy = SchedulingPolicy.DEFAULT_POLICY;
        QueuePlacementPolicy newPlacementPolicy = null;
        HashMap<FSQueueType, Set<String>> configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType queueType : FSQueueType.values()) {
            configuredQueues.put(queueType, new HashSet());
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(this.allocFile);
        Element root = doc.getDocumentElement();
        if (!"allocations".equals(root.getTagName())) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: top-level element not <allocations>");
        }
        NodeList elements = root.getChildNodes();
        ArrayList<Element> queueElements = new ArrayList<Element>();
        Element placementPolicyElement = null;
        for (int i = 0; i < elements.getLength(); ++i) {
            String text;
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("queue".equals(element.getTagName()) || "pool".equals(element.getTagName())) {
                queueElements.add(element);
                continue;
            }
            if ("user".equals(element.getTagName())) {
                String userName = element.getAttribute("name");
                NodeList fields = element.getChildNodes();
                for (int j = 0; j < fields.getLength(); ++j) {
                    Element field;
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element) || !"maxRunningApps".equals((field = (Element)fieldNode).getTagName())) continue;
                    String text2 = ((Text)field.getFirstChild()).getData().trim();
                    int val = Integer.parseInt(text2);
                    userMaxApps.put(userName, val);
                }
                continue;
            }
            if ("queueMaxResourcesDefault".equals(element.getTagName())) {
                Resource val;
                text = ((Text)element.getFirstChild()).getData().trim();
                queueMaxResourcesDefault = val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                continue;
            }
            if ("userMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                userMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("defaultFairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultFairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                if (defaultFairSharePreemptionTimeout != Long.MAX_VALUE) continue;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultFairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultMinSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultMinSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultFairSharePreemptionThreshold".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                defaultFairSharePreemptionThreshold = val = Math.max(Math.min(val, 1.0f), 0.0f);
                continue;
            }
            if ("queueMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                queueMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("queueMaxAMShareDefault".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                queueMaxAMShareDefault = val = Math.min(val, 1.0f);
                continue;
            }
            if ("defaultQueueSchedulingPolicy".equals(element.getTagName()) || "defaultQueueSchedulingMode".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                if (text.equalsIgnoreCase("FIFO")) {
                    throw new AllocationConfigurationException("Bad fair scheduler config file: defaultQueueSchedulingPolicy or defaultQueueSchedulingMode can't be FIFO.");
                }
                defaultSchedPolicy = SchedulingPolicy.parse(text);
                continue;
            }
            if ("queuePlacementPolicy".equals(element.getTagName())) {
                placementPolicyElement = element;
                continue;
            }
            LOG.warn("Bad element in allocations file: " + element.getTagName());
        }
        for (Element element : queueElements) {
            String parent = ROOT_POOL_NAME;
            if (element.getAttribute("name").equalsIgnoreCase(ROOT_POOL_NAME)) {
                if (queueElements.size() > 1) {
                    throw new AllocationConfigurationException("If configuring root queue, no other queues can be placed alongside it.");
                }
                parent = null;
            }
            this.loadQueue(parent, element, minQueueResources, maxQueueResources, maxChildQueueResources, queueMaxApps, userMaxApps, queueMaxAMShares, queueWeights, queuePolicies, minSharePreemptionTimeouts, fairSharePreemptionTimeouts, fairSharePreemptionThresholds, queueAcls, userQueryLimits, groupQueryLimits, configuredQueues, onlyCoordinators, nonPreemptableQueues);
        }
        Configuration conf = this.getConfig();
        newPlacementPolicy = placementPolicyElement != null ? QueuePlacementPolicy.fromXml(placementPolicyElement, configuredQueues, conf) : QueuePlacementPolicy.fromConfiguration(conf, configuredQueues);
        if (!minSharePreemptionTimeouts.containsKey(ROOT_POOL_NAME)) {
            minSharePreemptionTimeouts.put(ROOT_POOL_NAME, defaultMinSharePreemptionTimeout);
        }
        if (!fairSharePreemptionTimeouts.containsKey(ROOT_POOL_NAME)) {
            fairSharePreemptionTimeouts.put(ROOT_POOL_NAME, defaultFairSharePreemptionTimeout);
        }
        if (!fairSharePreemptionThresholds.containsKey(ROOT_POOL_NAME)) {
            fairSharePreemptionThresholds.put(ROOT_POOL_NAME, Float.valueOf(defaultFairSharePreemptionThreshold));
        }
        AllocationConfiguration info = new AllocationConfiguration(minQueueResources, maxQueueResources, maxChildQueueResources, queueMaxApps, userMaxApps, queueWeights, queueMaxAMShares, userMaxAppsDefault, queueMaxAppsDefault, queueMaxResourcesDefault, queueMaxAMShareDefault, queuePolicies, defaultSchedPolicy, minSharePreemptionTimeouts, fairSharePreemptionTimeouts, fairSharePreemptionThresholds, queueAcls, userQueryLimits, groupQueryLimits, onlyCoordinators, newPlacementPolicy, configuredQueues, nonPreemptableQueues);
        this.lastSuccessfulReload = this.clock.getTime();
        this.lastReloadAttemptFailed = false;
        this.verifyConfiguration(info);
        LOG.info("Completed loading allocation file " + this.allocFile);
        this.reloadListener.onReload(info);
    }

    private void loadQueue(String parentName, Element element, Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Resource> maxChildQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, Float> queueMaxAMShares, Map<String, ResourceWeights> queueWeights, Map<String, SchedulingPolicy> queuePolicies, Map<String, Long> minSharePreemptionTimeouts, Map<String, Long> fairSharePreemptionTimeouts, Map<String, Float> fairSharePreemptionThresholds, Map<String, Map<QueueACL, AccessControlList>> queueAcls, Map<String, Map<String, Integer>> userQueryLimits, Map<String, Map<String, Integer>> groupQueryLimits, Map<FSQueueType, Set<String>> configuredQueues, Map<String, Boolean> onlyCoordinators, Set<String> nonPreemptableQueues) throws AllocationConfigurationException {
        String queueName = CharMatcher.whitespace().trimFrom((CharSequence)element.getAttribute("name"));
        if (queueName.contains(".")) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: queue name (" + queueName + ") shouldn't contain period.");
        }
        if (queueName.isEmpty()) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: queue name shouldn't be empty or consist only of whitespace.");
        }
        if (parentName != null) {
            queueName = parentName + "." + queueName;
        }
        HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
        NodeList fields = element.getChildNodes();
        boolean isLeaf = true;
        for (int j = 0; j < fields.getLength(); ++j) {
            String text;
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if ("minResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                minQueueResources.put(queueName, val);
                continue;
            }
            if ("maxResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                maxQueueResources.put(queueName, val);
                continue;
            }
            if ("maxChildResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                maxChildQueueResources.put(queueName, val);
                continue;
            }
            if ("maxRunningApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                int val = Integer.parseInt(text);
                queueMaxApps.put(queueName, val);
                continue;
            }
            if ("maxAMShare".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                val = Math.min(val, 1.0f);
                queueMaxAMShares.put(queueName, Float.valueOf(val));
                continue;
            }
            if ("weight".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                double val = Double.parseDouble(text);
                queueWeights.put(queueName, new ResourceWeights((float)val));
                continue;
            }
            if ("minSharePreemptionTimeout".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                long val = Long.parseLong(text) * 1000L;
                minSharePreemptionTimeouts.put(queueName, val);
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                long val = Long.parseLong(text) * 1000L;
                fairSharePreemptionTimeouts.put(queueName, val);
                continue;
            }
            if ("fairSharePreemptionThreshold".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                val = Math.max(Math.min(val, 1.0f), 0.0f);
                fairSharePreemptionThresholds.put(queueName, Float.valueOf(val));
                continue;
            }
            if ("schedulingPolicy".equals(field.getTagName()) || "schedulingMode".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                SchedulingPolicy policy = SchedulingPolicy.parse(text);
                queuePolicies.put(queueName, policy);
                continue;
            }
            if ("aclSubmitApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                acls.put(QueueACL.SUBMIT_APPLICATIONS, new AccessControlList(text));
                continue;
            }
            if ("userQueryLimit".equals(field.getTagName())) {
                AllocationFileLoaderService.addQueryLimits(queueName, field, "userQueryLimit", userQueryLimits, "user");
                continue;
            }
            if ("groupQueryLimit".equals(field.getTagName())) {
                AllocationFileLoaderService.addQueryLimits(queueName, field, "groupQueryLimit", groupQueryLimits, "group");
                continue;
            }
            if ("aclAdministerApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                acls.put(QueueACL.ADMINISTER_QUEUE, new AccessControlList(text));
                continue;
            }
            if ("allowPreemptionFrom".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                if (Boolean.parseBoolean(text)) continue;
                nonPreemptableQueues.add(queueName);
                continue;
            }
            if ("queue".endsWith(field.getTagName()) || "pool".equals(field.getTagName())) {
                this.loadQueue(queueName, field, minQueueResources, maxQueueResources, maxChildQueueResources, queueMaxApps, userMaxApps, queueMaxAMShares, queueWeights, queuePolicies, minSharePreemptionTimeouts, fairSharePreemptionTimeouts, fairSharePreemptionThresholds, queueAcls, userQueryLimits, groupQueryLimits, configuredQueues, onlyCoordinators, nonPreemptableQueues);
                configuredQueues.get((Object)FSQueueType.PARENT).add(queueName);
                isLeaf = false;
                continue;
            }
            if (!"onlyCoordinators".equals(field.getTagName())) continue;
            text = ((Text)field.getFirstChild()).getData().trim();
            onlyCoordinators.put(queueName, Boolean.parseBoolean(text));
        }
        if (isLeaf) {
            if ("parent".equals(element.getAttribute("type"))) {
                configuredQueues.get((Object)FSQueueType.PARENT).add(queueName);
            } else {
                configuredQueues.get((Object)FSQueueType.LEAF).add(queueName);
            }
        }
        queueAcls.put(queueName, acls);
        if (maxQueueResources.containsKey(queueName) && minQueueResources.containsKey(queueName) && !Resources.fitsIn((Resource)minQueueResources.get(queueName), (Resource)maxQueueResources.get(queueName))) {
            LOG.warn(String.format("Queue %s has max resources %s less than min resources %s", queueName, maxQueueResources.get(queueName), minQueueResources.get(queueName)));
        }
    }

    public void verifyConfiguration(AllocationConfiguration allocationConfiguration) {
        Map<FSQueueType, Set<String>> configuredQueues = allocationConfiguration.getConfiguredQueues();
        Set<String> parentQueues = configuredQueues.get((Object)FSQueueType.PARENT);
        Set<String> leafQueues = configuredQueues.get((Object)FSQueueType.LEAF);
        if (parentQueues.size() == 1 && parentQueues.contains(ROOT_POOL_NAME)) {
            Map<String, Integer> rootUserQueryLimits = allocationConfiguration.getUserQueryLimits(ROOT_POOL_NAME);
            Map<String, Integer> rootGroupQueryLimits = allocationConfiguration.getGroupQueryLimits(ROOT_POOL_NAME);
            for (String leafQueue : leafQueues) {
                if (!leafQueue.startsWith(ROOT_POOL_NAME)) continue;
                Map<String, Integer> groupQueryLimits = allocationConfiguration.getGroupQueryLimits(leafQueue);
                Map<String, Integer> userQueryLimits = allocationConfiguration.getUserQueryLimits(leafQueue);
                this.verifyQueryLimits(leafQueue, "user", rootUserQueryLimits, userQueryLimits);
                this.verifyQueryLimits(leafQueue, "group", rootGroupQueryLimits, groupQueryLimits);
                AllocationFileLoaderService.verifyLeafAcls(allocationConfiguration, leafQueue);
            }
        }
    }

    private void verifyQueryLimits(String leafQueue, String type, Map<String, Integer> rootQueryLimits, Map<String, Integer> queryLimits) {
        for (Map.Entry<String, Integer> stringIntegerEntry : rootQueryLimits.entrySet()) {
            String key = stringIntegerEntry.getKey();
            int rootLimit = stringIntegerEntry.getValue();
            Integer leafLimit = queryLimits.get(key);
            if (leafLimit == null || leafLimit <= rootLimit) continue;
            LOG.warn("Potential misconfiguration in queue '" + leafQueue + "': the " + type + " limit for '" + key + "' of " + leafLimit + " is greater than the root limit " + rootLimit + " and so will have no effect");
        }
    }

    private static void verifyLeafAcls(AllocationConfiguration allocationConfiguration, String leafQueue) {
        AccessControlList queueAcl = allocationConfiguration.getQueueAcl(leafQueue, QueueACL.SUBMIT_APPLICATIONS);
        Collection users = queueAcl.getUsers();
        Collection groups = queueAcl.getGroups();
        if (!queueAcl.isAllAllowed() && users.isEmpty() && groups.isEmpty()) {
            LOG.warn("Potential misconfiguration in queue '" + leafQueue + "': no aclSubmitApps permissions were found, this will prevent query submission on this queue");
        }
    }

    public static interface Listener {
        public void onReload(AllocationConfiguration var1);
    }
}

