/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.impala.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.impala.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;

public class AllocationConfiguration {
    private static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    private static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private final Map<String, Resource> minQueueResources;
    @VisibleForTesting
    final Map<String, Resource> maxQueueResources;
    private final Resource queueMaxResourcesDefault;
    private final Map<String, Map<QueueACL, AccessControlList>> queueAcls;
    private final Map<String, Map<String, Integer>> userQueryLimits;
    private final Map<String, Map<String, Integer>> groupQueryLimits;
    private final Map<String, Boolean> onlyCoordinators;
    @VisibleForTesting
    QueuePlacementPolicy placementPolicy;
    @VisibleForTesting
    Map<FSQueueType, Set<String>> configuredQueues;

    public AllocationConfiguration(Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Resource> maxChildQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, ResourceWeights> queueWeights, Map<String, Float> queueMaxAMShares, int userMaxAppsDefault, int queueMaxAppsDefault, Resource queueMaxResourcesDefault, float queueMaxAMShareDefault, Map<String, SchedulingPolicy> schedulingPolicies, SchedulingPolicy defaultSchedulingPolicy, Map<String, Long> minSharePreemptionTimeouts, Map<String, Long> fairSharePreemptionTimeouts, Map<String, Float> fairSharePreemptionThresholds, Map<String, Map<QueueACL, AccessControlList>> queueAcls, Map<String, Map<String, Integer>> userQueryLimits, Map<String, Map<String, Integer>> groupQueryLimits, Map<String, Boolean> onlyCoordinators, QueuePlacementPolicy placementPolicy, Map<FSQueueType, Set<String>> configuredQueues, Set<String> nonPreemptableQueues) {
        this.minQueueResources = minQueueResources;
        this.maxQueueResources = maxQueueResources;
        this.queueMaxResourcesDefault = queueMaxResourcesDefault;
        this.queueAcls = queueAcls;
        this.userQueryLimits = userQueryLimits;
        this.groupQueryLimits = groupQueryLimits;
        this.onlyCoordinators = onlyCoordinators;
        this.placementPolicy = placementPolicy;
        this.configuredQueues = configuredQueues;
    }

    public AllocationConfiguration(Configuration conf) {
        this.minQueueResources = new HashMap<String, Resource>();
        this.maxQueueResources = new HashMap<String, Resource>();
        this.queueMaxResourcesDefault = Resources.unbounded();
        this.queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
        this.userQueryLimits = new HashMap<String, Map<String, Integer>>();
        this.groupQueryLimits = new HashMap<String, Map<String, Integer>>();
        this.onlyCoordinators = new HashMap<String, Boolean>();
        this.configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType queueType : FSQueueType.values()) {
            this.configuredQueues.put(queueType, new HashSet());
        }
        this.placementPolicy = QueuePlacementPolicy.fromConfiguration(conf, this.configuredQueues);
    }

    public AccessControlList getQueueAcl(String queue, QueueACL operation) {
        AccessControlList operationAcl;
        Map<QueueACL, AccessControlList> queueAcls = this.queueAcls.get(queue);
        if (queueAcls != null && (operationAcl = queueAcls.get(operation)) != null) {
            return operationAcl;
        }
        return queue.equals("root") ? EVERYBODY_ACL : NOBODY_ACL;
    }

    public Resource getMinResources(String queue) {
        Resource minQueueResource = this.minQueueResources.get(queue);
        return minQueueResource == null ? Resources.none() : minQueueResource;
    }

    void setMaxResources(String queue, Resource maxResource) {
        this.maxQueueResources.put(queue, maxResource);
    }

    public Resource getMaxResources(String queue) {
        Resource maxQueueResource = this.maxQueueResources.get(queue);
        if (maxQueueResource == null) {
            Resource minQueueResource = this.minQueueResources.get(queue);
            if (minQueueResource != null && Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)Resources.unbounded(), (Resource)minQueueResource, (Resource)this.queueMaxResourcesDefault)) {
                return minQueueResource;
            }
            return this.queueMaxResourcesDefault;
        }
        return maxQueueResource;
    }

    public boolean hasAccess(String queueName, QueueACL acl, UserGroupInformation user) {
        int lastPeriodIndex = queueName.length();
        while (lastPeriodIndex != -1) {
            String queue = queueName.substring(0, lastPeriodIndex);
            if (this.getQueueAcl(queue, acl).isUserAllowed(user)) {
                return true;
            }
            lastPeriodIndex = queueName.lastIndexOf(46, lastPeriodIndex - 1);
        }
        return false;
    }

    public Map<FSQueueType, Set<String>> getConfiguredQueues() {
        return this.configuredQueues;
    }

    public QueuePlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    public Map<String, Integer> getUserQueryLimits(String queueName) {
        Map<String, Integer> limits = this.userQueryLimits.get(queueName);
        return limits != null ? limits : Collections.emptyMap();
    }

    public Map<String, Integer> getGroupQueryLimits(String queueName) {
        Map<String, Integer> limits = this.groupQueryLimits.get(queueName);
        return limits != null ? limits : Collections.emptyMap();
    }

    public boolean isOnlyCoordinators(String queueName) {
        return this.onlyCoordinators.getOrDefault(queueName, Boolean.FALSE);
    }
}

