/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.infra.tableflattener;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class SchemaUtil {
    static final Map<Schema.Type, Schema.Type> BASE_TYPES = ImmutableMap.builder().put((Object)Schema.Type.STRING, (Object)Schema.Type.BYTES).put((Object)Schema.Type.FIXED, (Object)Schema.Type.BYTES).put((Object)Schema.Type.DOUBLE, (Object)Schema.Type.INT).put((Object)Schema.Type.FLOAT, (Object)Schema.Type.INT).put((Object)Schema.Type.LONG, (Object)Schema.Type.INT).build();

    static Schema.Field createField(String name, Schema.Type type) {
        return SchemaUtil.createField(name, type, null, null);
    }

    static Schema.Field createField(String name, Schema.Type type, String doc, Object defaultValue) {
        return new Schema.Field(name, Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)type)}), doc, defaultValue);
    }

    static Schema.Field createField(String name, Schema schema) {
        return SchemaUtil.createField(name, schema, null, null);
    }

    static Schema.Field createField(String name, Schema schema, String doc, Object defaultValue) {
        Preconditions.checkState((!SchemaUtil.schemaHasNesting(schema) ? 1 : 0) != 0);
        if (schema.getType() == Schema.Type.UNION) {
            return new Schema.Field(name, Schema.createUnion((List)schema.getTypes()), doc, defaultValue);
        }
        return SchemaUtil.createField(name, schema.getType(), doc, defaultValue);
    }

    static boolean recordHasField(GenericRecord record, String fieldName) {
        return record.getSchema().getField(fieldName) != null;
    }

    static Schema reduceUnionToNonNull(Schema unionSchema) {
        Schema reducedSchema = null;
        Schema.Type reducedBaseType = null;
        for (Schema schema : unionSchema.getTypes()) {
            Schema.Type baseType;
            if (schema.getType() == Schema.Type.NULL) continue;
            String logicalType = schema.getProp("logicalType");
            if (logicalType == null) {
                baseType = BASE_TYPES.containsKey(schema.getType()) ? BASE_TYPES.get(schema.getType()) : schema.getType();
            } else {
                Preconditions.checkState((boolean)logicalType.equals("decimal"));
                baseType = Schema.Type.INT;
            }
            if (reducedBaseType == null) {
                reducedSchema = schema;
                reducedBaseType = baseType;
                continue;
            }
            if (reducedBaseType == baseType) continue;
            throw new RuntimeException(String.format("Union contains incompatible types: %s", Joiner.on((String)" ,").join((Iterable)unionSchema.getTypes())));
        }
        if (reducedSchema == null) {
            throw new RuntimeException(String.format("Union schema contains no non-null types: %s", Joiner.on((String)" ,").join((Iterable)unionSchema.getTypes())));
        }
        return reducedSchema;
    }

    static boolean isNullable(Schema schema) {
        return schema.getType() == Schema.Type.NULL || schema.getType() == Schema.Type.UNION && SchemaUtil.unionIsNullable(schema);
    }

    static boolean unionIsNullable(Schema unionSchema) {
        for (Schema schema : unionSchema.getTypes()) {
            if (schema.getType() != Schema.Type.NULL) continue;
            return true;
        }
        return false;
    }

    static boolean isComplexType(Schema.Type type) {
        Preconditions.checkState((type != Schema.Type.UNION ? 1 : 0) != 0);
        return type == Schema.Type.ARRAY || type == Schema.Type.MAP || type == Schema.Type.RECORD;
    }

    static boolean isSimpleType(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            schema = SchemaUtil.reduceUnionToNonNull(schema);
        }
        return !SchemaUtil.isComplexType(schema.getType());
    }

    static boolean requiresChildDataset(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            schema = SchemaUtil.reduceUnionToNonNull(schema);
        }
        return schema.getType() == Schema.Type.ARRAY || schema.getType() == Schema.Type.MAP;
    }

    static boolean schemaHasNesting(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            schema = SchemaUtil.reduceUnionToNonNull(schema);
        }
        return SchemaUtil.isComplexType(schema.getType());
    }
}

