/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.infra.tableflattener;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetWriter;

public class FlattenedSchema {
    private long referenceId;
    private Schema.Field parentIdField_;
    private String name_;
    private Map<String, FlattenedSchema> childrenByName_ = Maps.newHashMap();
    private Dataset<GenericRecord> dataset_;
    private DatasetWriter<GenericRecord> datasetWriter_;
    private final String idFieldName_ = "id";

    public FlattenedSchema(String name) {
        this.name_ = name;
        this.referenceId = 0L;
    }

    public FlattenedSchema(String name, FlattenedSchema parent) {
        this(name);
        parent.childrenByName_.put(name, this);
    }

    public void open() {
        if (this.datasetWriter_ != null) {
            return;
        }
        this.datasetWriter_ = this.dataset_.newWriter();
        for (FlattenedSchema child : this.childrenByName_.values()) {
            child.open();
        }
    }

    public void write(GenericRecord record) {
        Preconditions.checkNotNull(this.datasetWriter_, (Object)"open() must be called before writing");
        this.datasetWriter_.write((Object)record);
    }

    public void close() {
        if (this.datasetWriter_ == null) {
            return;
        }
        this.datasetWriter_.close();
        for (FlattenedSchema child : this.childrenByName_.values()) {
            child.close();
        }
        this.datasetWriter_ = null;
    }

    public Long nextId() {
        return ++this.referenceId;
    }

    public String getIdFieldName() {
        return "id";
    }

    public String getCollectionValueFieldName() {
        return "value";
    }

    public String getArrayIdxFieldName() {
        return "idx";
    }

    public String getMapKeyFieldName() {
        return "key";
    }

    public String getChildOfCollectionName() {
        return this.name_ + FlattenedSchema.getNameSeparator() + "_values";
    }

    public String getIsNullFieldName(String fieldName) {
        return fieldName + "_is_null";
    }

    public static String getNameSeparator() {
        return "_";
    }

    public FlattenedSchema getChildOfCollection() {
        FlattenedSchema child = this.childrenByName_.get(this.getChildOfCollectionName());
        Preconditions.checkNotNull((Object)child);
        return child;
    }

    public String getChildOfRecordName(String parentFieldName) {
        return this.name_ + FlattenedSchema.getNameSeparator() + parentFieldName;
    }

    public FlattenedSchema getChildOfRecord(String parentFieldName) {
        FlattenedSchema child = this.childrenByName_.get(this.getChildOfRecordName(parentFieldName));
        Preconditions.checkNotNull((Object)child);
        return child;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.dataset_.getDescriptor().getSchema().toString(true));
        for (FlattenedSchema child : this.childrenByName_.values()) {
            builder.append("\n\nChild: ").append(child.name_).append("\n").append(child.toString());
        }
        return builder.toString();
    }

    public String getName() {
        return this.name_;
    }

    public Schema.Field getParentIdField() {
        return this.parentIdField_;
    }

    public void setParentIdField(Schema.Field parentIdField) {
        this.parentIdField_ = parentIdField;
    }

    public Dataset getDataset() {
        return this.dataset_;
    }

    public void setDataset(Dataset<GenericRecord> dataset) {
        this.dataset_ = dataset;
    }
}

