/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.infra.tableflattener;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.impala.infra.tableflattener.FlattenedSchema;
import org.apache.impala.infra.tableflattener.SchemaUtil;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;

public class SchemaFlattener {
    URI outputDir_;

    public SchemaFlattener(URI outputDir) {
        this.outputDir_ = outputDir;
    }

    public FlattenedSchema flatten(Schema srcSchema) {
        Preconditions.checkState((srcSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0);
        FlattenedSchema dstDataset = new FlattenedSchema(srcSchema.getName());
        LinkedList fields = Lists.newLinkedList();
        this.addRecordFields(srcSchema, dstDataset, fields, "");
        this.finishCreatingDataset(fields, dstDataset);
        return dstDataset;
    }

    private void addRecordFields(Schema srcSchema, FlattenedSchema dstDataset, LinkedList<Schema.Field> dstSchemaFields, String fieldNamePrefix) {
        Preconditions.checkState((srcSchema.getType() == Schema.Type.RECORD ? 1 : 0) != 0);
        for (Schema.Field field : srcSchema.getFields()) {
            Schema fieldSchema = field.schema();
            if (SchemaUtil.isSimpleType(fieldSchema)) {
                dstSchemaFields.add(SchemaUtil.createField(fieldNamePrefix + field.name(), fieldSchema, field.doc(), field.defaultVal()));
                continue;
            }
            if (SchemaUtil.isNullable(fieldSchema)) {
                dstSchemaFields.add(SchemaUtil.createField(fieldNamePrefix + dstDataset.getIsNullFieldName(field.name()), Schema.Type.BOOLEAN));
                fieldSchema = SchemaUtil.reduceUnionToNonNull(fieldSchema);
            }
            if (SchemaUtil.requiresChildDataset(fieldSchema)) {
                this.createChildDataset(dstDataset.getChildOfRecordName(field.name()), fieldSchema, dstSchemaFields, dstDataset);
                continue;
            }
            this.addRecordFields(fieldSchema, dstDataset, dstSchemaFields, fieldNamePrefix + field.name() + dstDataset.getNameSeparator());
        }
    }

    private void createChildDataset(String name, Schema srcSchema, LinkedList<Schema.Field> parentFields, FlattenedSchema parentDataset) {
        Schema valueSchema;
        if (parentFields.isEmpty() || !parentFields.getFirst().name().equals(parentDataset.getIdFieldName())) {
            parentFields.addFirst(SchemaUtil.createField(parentDataset.getIdFieldName(), Schema.Type.LONG));
        }
        FlattenedSchema childDataset = new FlattenedSchema(name, parentDataset);
        LinkedList fields = Lists.newLinkedList();
        String parentIdFieldName = parentDataset.getName() + childDataset.getNameSeparator() + childDataset.getIdFieldName();
        Schema.Field parentIdField = SchemaUtil.createField(parentIdFieldName, Schema.Type.LONG);
        childDataset.setParentIdField(parentIdField);
        fields.add(parentIdField);
        if (srcSchema.getType() == Schema.Type.ARRAY) {
            fields.add(SchemaUtil.createField(childDataset.getArrayIdxFieldName(), Schema.Type.LONG));
            valueSchema = srcSchema.getElementType();
        } else {
            Preconditions.checkState((srcSchema.getType() == Schema.Type.MAP ? 1 : 0) != 0);
            fields.add(SchemaUtil.createField(childDataset.getMapKeyFieldName(), Schema.Type.STRING));
            valueSchema = srcSchema.getValueType();
        }
        if (SchemaUtil.isSimpleType(valueSchema)) {
            fields.add(SchemaUtil.createField(childDataset.getCollectionValueFieldName(), valueSchema));
        } else {
            if (SchemaUtil.isNullable(valueSchema)) {
                fields.add(SchemaUtil.createField(childDataset.getIsNullFieldName(childDataset.getCollectionValueFieldName()), Schema.Type.BOOLEAN));
                valueSchema = SchemaUtil.reduceUnionToNonNull(valueSchema);
            }
            if (SchemaUtil.requiresChildDataset(valueSchema)) {
                this.createChildDataset(childDataset.getChildOfCollectionName(), valueSchema, fields, childDataset);
            } else {
                this.addRecordFields(valueSchema, childDataset, fields, childDataset.getCollectionValueFieldName() + childDataset.getNameSeparator());
            }
        }
        this.finishCreatingDataset(fields, childDataset);
    }

    private void finishCreatingDataset(List<Schema.Field> fields, FlattenedSchema dataset) {
        Schema childSchema = Schema.createRecord((String)dataset.getName(), null, null, (boolean)false);
        for (Schema.Field field : fields) {
            Preconditions.checkState((!SchemaUtil.schemaHasNesting(field.schema()) ? 1 : 0) != 0);
        }
        childSchema.setFields(fields);
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().format(Formats.PARQUET).schema(childSchema).build();
        dataset.setDataset((Dataset<GenericRecord>)((Dataset)Datasets.create((String)("dataset:" + this.createDir(dataset.getName())), (DatasetDescriptor)descriptor)));
    }

    private URI createDir(String name) {
        try {
            switch (this.outputDir_.getScheme().toUpperCase()) {
                case "FILE": {
                    java.nio.file.Path datasetPath = Paths.get(this.outputDir_).resolve(name);
                    datasetPath.toFile().mkdirs();
                    return datasetPath.toUri();
                }
                case "HDFS": {
                    Path outputDirPath = new Path(this.outputDir_);
                    Path datasetPath = new Path(outputDirPath, name);
                    outputDirPath.getFileSystem(new Configuration()).mkdirs(datasetPath);
                    return datasetPath.toUri();
                }
            }
            throw new NotImplementedException(String.format("Unexpected output dir scheme: %s", this.outputDir_.getScheme()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

