/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.infra.tableflattener;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.impala.infra.tableflattener.FileMigrator;
import org.apache.impala.infra.tableflattener.FlattenedSchema;
import org.apache.impala.infra.tableflattener.SchemaFlattener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Format;
import org.kitesdk.data.Formats;

public class Main {
    Options cliOptions_;
    DatasetDescriptor datasetDescr_;
    URI outputDir_;
    CommandLine commandLine_;

    void parseArgs(String[] args) throws ParseException, IOException {
        Format inputFormat;
        this.cliOptions_ = new Options();
        OptionBuilder.withLongOpt((String)"help");
        this.cliOptions_.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"input-data-format");
        OptionBuilder.withDescription((String)"The format of the input file. Ex, avro");
        this.cliOptions_.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"input-data-compression");
        OptionBuilder.withDescription((String)"The compression type of the input file. Ex, snappy");
        this.cliOptions_.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"input-schema-uri");
        OptionBuilder.withDescription((String)"The URI of the input file's schema. Ex, file://foo.avsc");
        this.cliOptions_.addOption(OptionBuilder.create((String)"s"));
        PosixParser parser = new PosixParser();
        this.commandLine_ = parser.parse(this.cliOptions_, args);
        if (this.commandLine_.hasOption("h")) {
            this.printHelp();
        }
        DatasetDescriptor.Builder datasetDescrBuilder = new DatasetDescriptor.Builder();
        String[] dataArgs = this.commandLine_.getArgs();
        if (dataArgs.length != 2) {
            this.printHelp("Exactly two arguments are required");
        }
        URI dataFile = URI.create(dataArgs[0]);
        this.outputDir_ = URI.create(dataArgs[1]);
        datasetDescrBuilder.location(dataFile);
        if (this.commandLine_.hasOption("f")) {
            inputFormat = Formats.fromString((String)this.commandLine_.getOptionValue("f"));
        } else {
            String ext;
            String dataFilePath = dataFile.getPath();
            if (dataFilePath == null || dataFilePath.isEmpty()) {
                this.printHelp("Data file URI is missing a path component: " + dataFile.toString());
            }
            if ((ext = FilenameUtils.getExtension((String)dataFilePath)).isEmpty()) {
                this.printHelp("The file format (-f) must be specified");
            }
            inputFormat = Formats.fromString((String)ext);
        }
        datasetDescrBuilder.format(inputFormat);
        if (this.commandLine_.hasOption("c")) {
            datasetDescrBuilder.compressionType(CompressionType.forName((String)this.commandLine_.getOptionValue("c")));
        }
        if (this.commandLine_.hasOption("s")) {
            datasetDescrBuilder.schemaUri(this.commandLine_.getOptionValue("s"));
        } else if (inputFormat == Formats.AVRO) {
            datasetDescrBuilder.schemaFromAvroDataFile(dataFile);
        } else if (inputFormat == Formats.PARQUET) {
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)new Configuration(), (Path)new Path(dataFile));
            datasetDescrBuilder.schema(new AvroSchemaConverter().convert(parquetMetadata.getFileMetaData().getSchema()));
        } else {
            this.printHelp("A schema (-s) is required for data format " + inputFormat.getName());
        }
        this.datasetDescr_ = datasetDescrBuilder.build();
    }

    void printHelp() {
        this.printHelp("");
    }

    void printHelp(String errorMessage) {
        PrintWriter printer = new PrintWriter(errorMessage.isEmpty() ? System.out : System.err);
        if (!errorMessage.isEmpty()) {
            printer.println("Error: " + errorMessage + "\n");
        }
        printer.println("Usage: [options] <input uri> <output uri>\n\ninput uri    The URI to the input file.\n               Ex, file:///foo.avro or hdfs://localhost:20500/foo.avro\noutput uri   The URI to the output directory. The dir must either not\n               exist or it must be empty.\n               Ex, file:///bar or hdfs://localhost:20500/bar\n\nOptions:");
        new HelpFormatter().printOptions(printer, 80, this.cliOptions_, 1, 3);
        printer.close();
        System.exit(errorMessage.isEmpty() ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exec(String[] args) throws ParseException, IOException {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.parseArgs(args);
        SchemaFlattener schemaFlattener = new SchemaFlattener(this.outputDir_);
        FlattenedSchema rootDataset = schemaFlattener.flatten(this.datasetDescr_.getSchema());
        java.nio.file.Path tempDatasetPath = Files.createTempDirectory(null, new FileAttribute[0]);
        try {
            Dataset srcDataset = (Dataset)Datasets.create((String)("dataset:file:" + tempDatasetPath.toString()), (DatasetDescriptor)this.datasetDescr_);
            FileMigrator migrator = new FileMigrator();
            migrator.migrate((Dataset<GenericRecord>)srcDataset, rootDataset);
        }
        finally {
            FileUtils.deleteDirectory((File)tempDatasetPath.toFile());
        }
    }

    public static void main(String[] args) throws Exception {
        new Main().exec(args);
    }
}

