/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.infra.tableflattener;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.impala.infra.tableflattener.FlattenedSchema;
import org.apache.impala.infra.tableflattener.SchemaUtil;
import org.kitesdk.data.Dataset;

public class FileMigrator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Dataset<GenericRecord> src, FlattenedSchema dst) {
        dst.open();
        try {
            for (GenericRecord record : src.newReader()) {
                this.writeRecord(record, dst);
            }
        }
        finally {
            dst.close();
        }
    }

    private void writeRecord(GenericRecord srcRecord, FlattenedSchema dstDataset) {
        GenericData.Record dstRecord = this.createRecord(null, dstDataset);
        this.writeRecordFields(srcRecord, dstRecord, dstDataset, "");
        dstDataset.write((GenericRecord)dstRecord);
    }

    private GenericData.Record createRecord(Long dstParentId, FlattenedSchema dstDataset) {
        Schema.Field idField;
        GenericData.Record record = new GenericData.Record(dstDataset.getDataset().getDescriptor().getSchema());
        if (dstDataset.getParentIdField() != null) {
            Preconditions.checkNotNull((Object)dstParentId);
            record.put(dstDataset.getParentIdField().name(), (Object)dstParentId);
        }
        if ((idField = record.getSchema().getField(dstDataset.getIdFieldName())) != null) {
            record.put(idField.name(), (Object)dstDataset.nextId());
        }
        return record;
    }

    private void writeRecordFields(GenericRecord srcRecord, GenericData.Record dstRecord, FlattenedSchema dstDataset, String fieldNamePrefix) {
        for (Schema.Field field : srcRecord.getSchema().getFields()) {
            Object value;
            if (SchemaUtil.recordHasField(srcRecord, field.name())) {
                value = srcRecord.get(field.name());
            } else {
                Preconditions.checkNotNull((Object)field.defaultVal());
                value = GenericData.get().getDefaultValue(field);
            }
            this.writeValue(value, field.schema(), field.name(), dstRecord, dstDataset, fieldNamePrefix);
        }
    }

    private void writeValue(Object srcValue, Schema srcSchema, String srcFieldName, GenericData.Record dstRecord, FlattenedSchema dstDataset, String fieldNamePrefix) {
        FlattenedSchema childDataset;
        String dstFieldName = fieldNamePrefix + (srcFieldName == null ? dstDataset.getCollectionValueFieldName() : srcFieldName);
        if (!SchemaUtil.schemaHasNesting(srcSchema)) {
            dstRecord.put(dstFieldName, srcValue);
            return;
        }
        if (SchemaUtil.isNullable(srcSchema)) {
            dstRecord.put(dstDataset.getIsNullFieldName(dstFieldName), (Object)(srcValue == null ? 1 : 0));
            if (srcValue == null) {
                return;
            }
            if (srcSchema.getType() == Schema.Type.UNION) {
                srcSchema = (Schema)srcSchema.getTypes().get(GenericData.get().resolveUnion(srcSchema, srcValue));
            }
        }
        if (!SchemaUtil.requiresChildDataset(srcSchema)) {
            this.writeRecordFields((GenericRecord)srcValue, dstRecord, dstDataset, fieldNamePrefix + (srcFieldName == null ? dstDataset.getCollectionValueFieldName() : srcFieldName) + dstDataset.getNameSeparator());
            return;
        }
        Long dstParentId = (Long)dstRecord.get(dstDataset.getIdFieldName());
        Preconditions.checkNotNull((Object)dstParentId);
        FlattenedSchema flattenedSchema = childDataset = srcFieldName == null ? dstDataset.getChildOfCollection() : dstDataset.getChildOfRecord(srcFieldName);
        if (srcSchema.getType() == Schema.Type.ARRAY) {
            this.writeArray((List)srcValue, srcSchema.getElementType(), dstParentId, childDataset);
        } else {
            Preconditions.checkState((srcSchema.getType() == Schema.Type.MAP ? 1 : 0) != 0);
            this.writeMap((Map)srcValue, srcSchema.getValueType(), dstParentId, childDataset);
        }
    }

    private void writeArray(List srcValues, Schema srcSchema, Long dstParentId, FlattenedSchema dstDataset) {
        ListIterator it = srcValues.listIterator();
        while (it.hasNext()) {
            Object value = it.next();
            GenericData.Record record = this.createRecord(dstParentId, dstDataset);
            record.put(dstDataset.getArrayIdxFieldName(), (Object)it.previousIndex());
            this.writeValue(value, srcSchema, null, record, dstDataset, "");
            dstDataset.write((GenericRecord)record);
        }
    }

    private void writeMap(Map srcValues, Schema srcSchema, Long dstParentId, FlattenedSchema dstDataset) {
        for (Map.Entry entry : srcValues.entrySet()) {
            GenericData.Record record = this.createRecord(dstParentId, dstDataset);
            record.put(dstDataset.getMapKeyFieldName(), entry.getKey());
            this.writeValue(entry.getValue(), srcSchema, null, record, dstDataset, "");
            dstDataset.write((GenericRecord)record);
        }
    }
}

