/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.puffindatagenerator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.puffin.PuffinWriter;

public class PuffinDataGenerator {
    public static String SKETCH_TYPE = "apache-datasketches-theta-v1";
    public static final String TABLE_LOCATION_PLACEHOLDER = "TABLE_LOCATION_PLACEHOLDER";
    public static final String UUID_PLACEHOLDER = "UUID_PLACEHOLDER";
    public static final long SEQUENCE_NUMBER = 0L;
    public static final List<ByteBuffer> sketches = PuffinDataGenerator.createSketches();
    private final String localOutputDir_;
    private final long snapshotId_;
    private final List<Long> oldSnapshotIds_;
    private final ObjectMapper mapper_;
    private final JsonNode metadataJsonTemplate_;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String metadataJsonTemplatePath = "./testdata/ice_puffin/00003-442f9acd-964c-43d7-92b8-e0737a39719a.metadata.json";
        String localOutputDir = "./puffin_files/";
        PuffinDataGenerator generator = new PuffinDataGenerator("./testdata/ice_puffin/00003-442f9acd-964c-43d7-92b8-e0737a39719a.metadata.json", "./puffin_files/");
        generator.writeFileWithAllStats();
        generator.writeAllStatsTwoFiles();
        generator.writeDuplicateStatsInFile();
        generator.writeDuplicateStatsInTwoFiles();
        generator.writeOneFileCurrentOneNot();
        generator.writeNotAllBlobsCurrent();
        generator.writeMissingFile();
        generator.writeOneFileCorruptOneNot();
        generator.writeAllFilesCorrupt();
        generator.writeFileContainsInvalidFieldId();
        generator.writeStatForUnsupportedType();
        generator.writeFileWithInvalidAndCorruptSketches();
        generator.writeFileMetadataNdvOkFileCorrupt();
        generator.writeFileMultipleFieldIds();
        generator.writeSomeBlobsCurrentSomeNotInTwoFiles();
    }

    public PuffinDataGenerator(String metadataJsonTemplatePath, String localOutputDir) throws FileNotFoundException, JsonProcessingException {
        String metadataJsonStr;
        this.localOutputDir_ = localOutputDir;
        try (Scanner scanner = new Scanner(new File(metadataJsonTemplatePath));){
            metadataJsonStr = scanner.useDelimiter("\\Z").next();
        }
        this.snapshotId_ = PuffinDataGenerator.getSnapshotIdFromMetadataJson(metadataJsonStr);
        String tableLocation = PuffinDataGenerator.getTableLocationFromMetadataJson(metadataJsonStr);
        metadataJsonStr = metadataJsonStr.replace(tableLocation, TABLE_LOCATION_PLACEHOLDER);
        this.mapper_ = new ObjectMapper();
        this.metadataJsonTemplate_ = this.mapper_.readTree(metadataJsonStr);
        List<Long> snapshotIds = this.getSnapshotIds();
        snapshotIds.remove(this.snapshotId_);
        this.oldSnapshotIds_ = snapshotIds;
    }

    private static long getSnapshotIdFromMetadataJson(String metadataJsonStr) {
        Pattern regex = Pattern.compile("\"current-snapshot-id\" ?: ?([0-9]+)");
        Matcher matcher = regex.matcher(metadataJsonStr);
        boolean match = matcher.find();
        Preconditions.checkState((boolean)match);
        String snapshotIdStr = matcher.group(1);
        return Long.parseLong(snapshotIdStr);
    }

    private static String getTableLocationFromMetadataJson(String metadataJsonStr) {
        Pattern regex = Pattern.compile("\"location\" ?: ?\"(.*)\"");
        Matcher matcher = regex.matcher(metadataJsonStr);
        boolean match = matcher.find();
        Preconditions.checkState((boolean)match);
        return matcher.group(1);
    }

    private List<Long> getSnapshotIds() {
        JsonNode snapshots = this.metadataJsonTemplate_.findValue("snapshots");
        List snapshotIds = snapshots.findValues("snapshot-id");
        ArrayList<Long> res = new ArrayList<Long>();
        for (JsonNode node : snapshotIds) {
            res.add(node.asLong());
        }
        return res;
    }

    private String getPuffinFilePrefix() {
        return "TABLE_LOCATION_PLACEHOLDER/metadata/";
    }

    private void writeFileWithAllStats() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 4, 4));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 5, 5));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 6, 6));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 7, 7));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 8, 8));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 9, 9));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("all_stats.stats", this.snapshotId_, blobs, false));
        this.writeFilesForScenario(puffinFiles, "all_stats_in_1_file.metadata.json");
    }

    private void writeAllStatsTwoFiles() throws IOException {
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 4, 4));
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 5, 5));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 6, 6));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 7, 7));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 8, 8));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 9, 9));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("stats_divided1.stats", this.snapshotId_, blobs1, false));
        puffinFiles.add(new FileData("stats_divided2.stats", this.snapshotId_, blobs2, true));
        this.writeFilesForScenario(puffinFiles, "stats_divided.metadata.json");
    }

    private void writeDuplicateStatsInFile() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 3));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("duplicate_stats_in_1_file.stats", this.snapshotId_, blobs, true));
        this.writeFilesForScenario(puffinFiles, "duplicate_stats_in_1_file.metadata.json");
    }

    private void writeDuplicateStatsInTwoFiles() throws IOException {
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 5));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("duplicate_stats_in_2_files1.stats", this.snapshotId_, blobs1, true));
        puffinFiles.add(new FileData("duplicate_stats_in_2_files2.stats", this.snapshotId_, blobs2, false));
        this.writeFilesForScenario(puffinFiles, "duplicate_stats_in_2_files.metadata.json");
    }

    private void writeOneFileCurrentOneNot() throws IOException {
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        long notCurrentSnapshotId = this.oldSnapshotIds_.get(0);
        blobs2.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 3, 3));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 4, 4));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("current_snapshot_id.stats", this.snapshotId_, blobs1, true));
        puffinFiles.add(new FileData("not_current_snapshot_id.stats", notCurrentSnapshotId, blobs2, true));
        this.writeFilesForScenario(puffinFiles, "one_file_current_one_not.metadata.json");
    }

    private void writeNotAllBlobsCurrent() throws IOException {
        long notCurrentSnapshotId = this.oldSnapshotIds_.get(0);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        blobs.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 3, 3));
        blobs.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 4, 4));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("not_all_blobs_current.stats", this.snapshotId_, blobs, true));
        this.writeFilesForScenario(puffinFiles, "not_all_blobs_current.metadata.json");
    }

    private void writeSomeBlobsCurrentSomeNotInTwoFiles() throws IOException {
        long notCurrentSnapshotId = this.oldSnapshotIds_.get(0);
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 2, 4));
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        blobs2.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 1, 5));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        blobs2.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 3, 8));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs2.add(PuffinDataGenerator.createBlob(notCurrentSnapshotId, 0L, 3, 6));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("some_blobs_current_some_not_in_2_files1.stats", this.snapshotId_, blobs1, true));
        puffinFiles.add(new FileData("some_blobs_current_some_not_in_2_files2.stats", notCurrentSnapshotId, blobs2, true));
        this.writeFilesForScenario(puffinFiles, "some_blobs_current_some_not_in_2_files.metadata.json");
    }

    private void writeMissingFile() throws IOException {
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 4, 4));
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(new FileData("missing_file.stats", this.snapshotId_, blobs1, false, true));
        puffinFiles.add(new FileData("existing_file.stats", this.snapshotId_, blobs2, true));
        this.writeFilesForScenario(puffinFiles, "missing_file.metadata.json");
    }

    private void writeOneFileCorruptOneNot() throws IOException {
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        FileData corruptFile = new FileData("corrupt_file.stats", this.snapshotId_, blobs1, false);
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 4, 4));
        FileData nonCorruptFile = new FileData("non_corrupt_file.stats", this.snapshotId_, blobs2, false);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(corruptFile);
        puffinFiles.add(nonCorruptFile);
        this.writeFilesForScenario(puffinFiles, "one_file_corrupt_one_not.metadata.json");
        this.corruptFile(corruptFile.filename);
    }

    private void writeAllFilesCorrupt() throws IOException {
        ArrayList<Blob> blobs1 = new ArrayList<Blob>();
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        blobs1.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 2, 2));
        FileData corruptFile1 = new FileData("corrupt_file1.stats", this.snapshotId_, blobs1, true);
        ArrayList<Blob> blobs2 = new ArrayList<Blob>();
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs2.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 4, 4));
        FileData corruptFile2 = new FileData("corrupt_file2.stats", this.snapshotId_, blobs2, true);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(corruptFile1);
        puffinFiles.add(corruptFile2);
        this.writeFilesForScenario(puffinFiles, "all_files_corrupt.metadata.json");
        this.corruptFile(corruptFile1.filename);
        this.corruptFile(corruptFile2.filename);
    }

    private void writeFileContainsInvalidFieldId() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        int invalid_field_id = 200;
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, invalid_field_id, 2));
        FileData corruptFile1 = new FileData("file_contains_invalid_field_id.stats", this.snapshotId_, blobs, true);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(corruptFile1);
        this.writeFilesForScenario(puffinFiles, "file_contains_invalid_field_id.metadata.json");
    }

    private void writeStatForUnsupportedType() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 2));
        int unsupported_field_id = 10;
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, unsupported_field_id, 2));
        FileData corruptFile1 = new FileData("stats_for_unsupported_type.stats", this.snapshotId_, blobs, true);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(corruptFile1);
        this.writeFilesForScenario(puffinFiles, "stats_for_unsupported_type.metadata.json");
    }

    private void writeFileWithInvalidAndCorruptSketches() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 1, 1));
        String invalidSketchType = "invalidSketchType";
        blobs.add(new Blob("invalidSketchType", Arrays.asList(2), this.snapshotId_, 0L, sketches.get(1)));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 3, 3));
        blobs.add(PuffinDataGenerator.createBlobCorruptSketch(this.snapshotId_, 0L, 4, 4, false));
        blobs.add(PuffinDataGenerator.createBlob(this.snapshotId_, 0L, 5, 5));
        FileData fileData = new FileData("invalidAndCorruptSketches.stats", this.snapshotId_, blobs, true);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(fileData);
        this.writeFilesForScenario(puffinFiles, "invalidAndCorruptSketches.metadata.json");
    }

    private void writeFileMetadataNdvOkFileCorrupt() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        blobs.add(PuffinDataGenerator.createBlobCorruptSketch(this.snapshotId_, 0L, 1, 1, true));
        blobs.add(PuffinDataGenerator.createBlobCorruptSketch(this.snapshotId_, 0L, 2, 2, true));
        FileData corruptFile = new FileData("metadata_ndv_ok_sketches_corrupt.stats", this.snapshotId_, blobs, true);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(corruptFile);
        this.writeFilesForScenario(puffinFiles, "metadata_ndv_ok_stats_file_corrupt.metadata.json");
    }

    private void writeFileMultipleFieldIds() throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        List<Integer> fieldIds = Arrays.asList(1, 2);
        blobs.add(PuffinDataGenerator.createBlobMultipleFieldIds(this.snapshotId_, 0L, fieldIds, 1, true));
        FileData file = new FileData("multiple_field_ids.stats", this.snapshotId_, blobs, true);
        ArrayList<FileData> puffinFiles = new ArrayList<FileData>();
        puffinFiles.add(file);
        this.writeFilesForScenario(puffinFiles, "multiple_field_ids.metadata.json");
    }

    private static ByteBuffer createSketchWithNdv(int ndv) {
        UpdateSketch sketch = UpdateSketch.builder().build();
        for (int i = 0; i < ndv; ++i) {
            sketch.update((long)i);
        }
        return ByteBuffer.wrap(sketch.compact().toByteArray());
    }

    private static List<ByteBuffer> createSketches() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 1; i <= 9; ++i) {
            builder.add((Object)PuffinDataGenerator.createSketchWithNdv(i));
        }
        return builder.build();
    }

    private static Blob createBlob(long snapshotId, long sequenceNumber, int fieldId, int ndv) {
        return PuffinDataGenerator.createBlob(snapshotId, sequenceNumber, fieldId, ndv, false);
    }

    private static Blob createBlob(long snapshotId, long sequenceNumber, int fieldId, int ndv, boolean addNdvProperty) {
        return PuffinDataGenerator.createBlobMultipleFieldIds(snapshotId, sequenceNumber, Arrays.asList(fieldId), ndv, addNdvProperty);
    }

    private static Blob createBlobCorruptSketch(long snapshotId, long sequenceNumber, int fieldId, int ndv, boolean addNdvProperty) {
        byte[] bytes = new byte[]{0, 0};
        ByteBuffer corruptSketch = ByteBuffer.wrap(bytes);
        return PuffinDataGenerator.createBlobWithProperties(snapshotId, sequenceNumber, Arrays.asList(fieldId), ndv, corruptSketch, addNdvProperty);
    }

    private static Blob createBlobMultipleFieldIds(long snapshotId, long sequenceNumber, List<Integer> fieldIds, int ndv, boolean addNdvProperty) {
        return PuffinDataGenerator.createBlobWithProperties(snapshotId, sequenceNumber, fieldIds, ndv, sketches.get(ndv - 1), addNdvProperty);
    }

    private static Blob createBlobWithProperties(long snapshotId, long sequenceNumber, List<Integer> fieldIds, int ndv, ByteBuffer datasketch, boolean addNdvProperty) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (addNdvProperty) {
            properties.put("ndv", Integer.toString(ndv));
        }
        return new Blob(SKETCH_TYPE, fieldIds, snapshotId, sequenceNumber, datasketch, null, properties);
    }

    private void writeFilesForScenario(List<FileData> puffinFiles, String statsJsonFile) throws IOException {
        ArrayNode jsonStatsList = this.mapper_.createArrayNode();
        for (FileData fileData : puffinFiles) {
            jsonStatsList.add((JsonNode)this.writeBlobsToFile(fileData));
        }
        this.writeMetadataJsonWithStatsToFile(statsJsonFile, jsonStatsList);
    }

    private ObjectNode writeBlobsToFile(FileData fileData) throws IOException {
        String localOutfile = this.localOutputDir_ + fileData.filename;
        long fileSize = 340L;
        long footerSize = 288L;
        if (!fileData.missingFile) {
            Puffin.WriteBuilder writeBuilder = Puffin.write((OutputFile)HadoopOutputFile.fromLocation((CharSequence)localOutfile, (Configuration)new Configuration()));
            writeBuilder.createdBy("Impala Puffin Data Generator");
            if (fileData.compressBlobs) {
                writeBuilder.compressBlobs(PuffinCompressionCodec.ZSTD);
            }
            if (fileData.compressFooter) {
                writeBuilder.compressFooter();
            }
            PuffinWriter writer = writeBuilder.build();
            for (Blob blob : fileData.blobs) {
                writer.add(blob);
            }
            writer.finish();
            writer.close();
            fileSize = writer.fileSize();
            footerSize = writer.footerSize();
        }
        ObjectNode statsNode = this.mapper_.createObjectNode();
        statsNode.put("snapshot-id", fileData.snapshotId);
        statsNode.put("statistics-path", this.getPuffinFilePrefix() + fileData.filename);
        statsNode.put("file-size-in-bytes", fileSize);
        statsNode.put("file-footer-size-in-bytes", footerSize);
        statsNode.put("blob-metadata", (JsonNode)this.blobsToJson(fileData.blobs));
        return statsNode;
    }

    private ArrayNode blobsToJson(List<Blob> blobs) throws JsonProcessingException {
        ArrayNode list = this.mapper_.createArrayNode();
        for (Blob blob : blobs) {
            list.add((JsonNode)this.blobMetadataToJson(blob));
        }
        return list;
    }

    private ObjectNode blobMetadataToJson(Blob blob) throws JsonProcessingException {
        ObjectNode blobNode = this.mapper_.createObjectNode();
        blobNode.put("type", blob.type());
        blobNode.put("snapshot-id", blob.snapshotId());
        blobNode.put("sequence-number", blob.sequenceNumber());
        ArrayNode fieldsList = this.mapper_.createArrayNode();
        Iterator iterator = blob.inputFields().iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            fieldsList.add(fieldId);
        }
        blobNode.set("fields", (JsonNode)fieldsList);
        if (!blob.properties().isEmpty()) {
            ObjectNode properties = this.mapper_.createObjectNode();
            for (Map.Entry entry : blob.properties().entrySet()) {
                properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            blobNode.set("properties", (JsonNode)properties);
        }
        return blobNode;
    }

    private void writeMetadataJsonWithStatsToFile(String outfile, ArrayNode stats) throws IOException {
        JsonNode metadataJson = this.metadataJsonTemplate_.deepCopy();
        String uuidKey = "table-uuid";
        ObjectNode uuidParent = (ObjectNode)metadataJson.findParent(uuidKey);
        uuidParent.put(uuidKey, UUID_PLACEHOLDER);
        ObjectNode statsParent = (ObjectNode)metadataJson.findParent("statistics");
        statsParent.put("statistics", (JsonNode)stats);
        String outfilePath = this.localOutputDir_ + outfile;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfilePath), "utf-8"));){
            String jsonString = this.mapper_.writerWithDefaultPrettyPrinter().writeValueAsString((Object)metadataJson);
            writer.write(jsonString);
        }
    }

    private void corruptFile(String filename) throws FileNotFoundException, IOException {
        String filePath = this.localOutputDir_ + filename;
        int fileSize = (int)new File(filePath).length();
        byte[] bytes = new byte[fileSize];
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            int n = ((InputStream)inputStream).read(bytes);
        }
        var6_6 = null;
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            int magicLength = 4;
            int bytesToOmit = 8;
            ((OutputStream)outputStream).write(bytes, 8, bytes.length - 8);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    private static class FileData {
        public final String filename;
        public final long snapshotId;
        public final List<Blob> blobs;
        public final boolean compressBlobs;
        public final boolean compressFooter;
        public final boolean missingFile;

        public FileData(String filename, long snapshotId, List<Blob> blobs, boolean compressBlobs, boolean missingFile) {
            this.filename = filename;
            this.snapshotId = snapshotId;
            this.blobs = blobs;
            this.compressBlobs = compressBlobs;
            this.compressFooter = false;
            this.missingFile = missingFile;
        }

        public FileData(String filename, long snapshotId, List<Blob> blobs, boolean compressBlobs) {
            this(filename, snapshotId, blobs, compressBlobs, false);
        }
    }
}

