/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SinglePrimitiveValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

class HiveDecimalPrimitiveValueBoundaryScanner
extends SinglePrimitiveValueBoundaryScanner<HiveDecimalWritable> {
    public HiveDecimalPrimitiveValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public Object computeValue(Object row) throws HiveException {
        Object value = ((Object[])row)[0];
        return value == null ? null : new HiveDecimalWritable((HiveDecimalWritable)value);
    }

    @Override
    public boolean isDistanceGreaterPrimitive(HiveDecimalWritable d1, HiveDecimalWritable d2, int amt) {
        if (d1 != null && d2 != null) {
            return d1.getHiveDecimal().subtract(d2.getHiveDecimal()).intValue() > amt;
        }
        return d1 != null || d2 != null;
    }

    @Override
    public boolean isEqualPrimitive(HiveDecimalWritable d1, HiveDecimalWritable d2) {
        if (d1 != null && d2 != null) {
            return d1.equals(d2);
        }
        return d1 == null && d2 == null;
    }
}

