/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MaskHashTransformer
extends AbstractTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(MaskHashTransformer.class);
    private boolean isSHA512 = false;

    MaskHashTransformer() {
    }

    @Override
    public void init(ObjectInspector[] arguments, int startIdx) {
    }

    public void setSHA512(boolean val) {
        this.isSHA512 = val;
    }

    @Override
    String transform(String value) {
        if (this.getIsSHA512FromSessionConf() || this.isSHA512) {
            LOG.info("Using SHA512 for masking");
            return DigestUtils.sha512Hex((String)value);
        }
        LOG.info("Using SHA256 for masking");
        return DigestUtils.sha256Hex((String)value);
    }

    private boolean getIsSHA512FromSessionConf() {
        if (SessionState.get() != null) {
            return "sha512".equalsIgnoreCase(HiveConf.getVar(SessionState.get().getConf(), HiveConf.ConfVars.HIVE_MASKING_ALGO).trim());
        }
        return false;
    }

    @Override
    Byte transform(Byte value) {
        return null;
    }

    @Override
    Short transform(Short value) {
        return null;
    }

    @Override
    Integer transform(Integer value) {
        return null;
    }

    @Override
    Long transform(Long value) {
        return null;
    }

    @Override
    Date transform(Date value) {
        return null;
    }
}

