/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import hiveexec.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFGetSplits;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="get_llap_splits", value="_FUNC_(string,int) - Returns an array of length int serialized splits for the referenced tables string. Passing length 0 returns only schema data for the compiled query. The order of splits is: schema-split, plan-split, 0, 1, 2...where 0, 1, 2...are the actual splits This UDTF is for internal use by LlapBaseInputFormat and not to be invoked explicitly")
@UDFType(deterministic=false)
public class GenericUDTFGetSplits2
extends GenericUDTFGetSplits {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDTFGetSplits2.class);

    @Override
    public StructObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        LOG.debug("initializing GenericUDFGetSplits2");
        this.validateInput(arguments);
        List<String> names = Arrays.asList("type", "split");
        List<ObjectInspector> fieldOIs = Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector);
        StandardStructObjectInspector outputOI = ObjectInspectorFactory.getStandardStructObjectInspector(names, fieldOIs);
        LOG.debug("done initializing GenericUDFGetSplits2");
        return outputOI;
    }

    @Override
    public void process(Object[] arguments) throws HiveException {
        try {
            this.initArgs(arguments);
            GenericUDTFGetSplits.SplitResult splitResult = this.getSplitResult(true);
            this.forwardOutput(splitResult);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void forwardOutput(GenericUDTFGetSplits.SplitResult splitResult) throws IOException, HiveException {
        for (Map.Entry<String, InputSplit> entry : this.transformSplitResult(splitResult).entrySet()) {
            Object[] os = new Object[2];
            os[0] = entry.getKey();
            InputSplit split = entry.getValue();
            this.bos.reset();
            split.write(this.dos);
            os[1] = this.bos.toByteArray();
            this.forward(os);
        }
    }

    private Map<String, InputSplit> transformSplitResult(GenericUDTFGetSplits.SplitResult splitResult) {
        LinkedHashMap<String, InputSplit> splitMap = new LinkedHashMap<String, InputSplit>();
        splitMap.put("schema-split", splitResult.schemaSplit);
        if (splitResult.actualSplits != null && splitResult.actualSplits.length > 0) {
            Preconditions.checkNotNull(splitResult.planSplit);
            splitMap.put("plan-split", splitResult.planSplit);
            for (int i = 0; i < splitResult.actualSplits.length; ++i) {
                splitMap.put("" + i, splitResult.actualSplits[i]);
            }
        }
        return splitMap;
    }
}

