/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.udf.generic.BaseMaskUDF;
import org.apache.hadoop.hive.ql.udf.generic.MaskHashTransformer;

@Description(name="mask_hash", value="returns hash of the given value", extended="Examples:\n   mask_hash(value)\n Arguments:\n   value - value to mask. Supported types: STRING, VARCHAR, CHAR")
public class GenericUDFMaskHash
extends BaseMaskUDF {
    public static final String UDF_NAME = "mask_hash";

    @Override
    public void configure(MapredContext context) {
        boolean isSha512 = "sha512".equalsIgnoreCase(HiveConf.getVar((Configuration)context.getJobConf(), HiveConf.ConfVars.HIVE_MASKING_ALGO).trim());
        ((MaskHashTransformer)this.transformer).setSHA512(isSha512);
    }

    public GenericUDFMaskHash() {
        super(new MaskHashTransformer(), UDF_NAME);
    }
}

