/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.InstantFormatter;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

@Description(name="date_format", value="_FUNC_(date/timestamp/string, fmt) - converts a date/timestamp/string to a value of string in the format specified by the date format fmt.", extended="Supported formats are defined by the underlying formatter implementation (hive.datetime.formatter). Second argument fmt should be constant.\nExample: > SELECT _FUNC_('2015-04-08', 'y');\n '2015'")
public class GenericUDFDateFormat
extends GenericUDF {
    private final transient ObjectInspectorConverters.Converter[] tsConverters = new ObjectInspectorConverters.Converter[2];
    private final transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Text output = new Text();
    private transient ZoneId timeZone;
    private transient InstantFormatter formatter;
    private transient String fmtStr;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 1, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.obtainTimestampConverter(arguments, 0, this.tsInputTypes, this.tsConverters);
        HiveConf conf = SessionState.getSessionConf();
        if (this.formatter == null) {
            this.formatter = InstantFormatter.ofConfiguration(conf);
        }
        if (this.timeZone == null) {
            this.timeZone = conf.getLocalTimeZone();
        }
        if (!(arguments[1] instanceof ConstantObjectInspector)) {
            throw new UDFArgumentTypeException(1, this.getFuncName() + " only takes constant as " + this.getArgOrder(1) + " argument");
        }
        this.fmtStr = this.getConstantStringValue(arguments, 1);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public void configure(MapredContext context) {
        super.configure(context);
        if (context != null) {
            this.formatter = InstantFormatter.ofConfiguration((Configuration)context.getJobConf());
            String timeZoneStr = HiveConf.getVar((Configuration)context.getJobConf(), HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE);
            this.timeZone = TimestampTZUtil.parseTimeZone(timeZoneStr);
        }
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.fmtStr == null) {
            return null;
        }
        Timestamp ts = this.getTimestampValue(arguments, 0, this.tsConverters);
        if (ts == null) {
            return null;
        }
        try {
            String res = this.formatter.format(TimestampTZUtil.convert(ts, this.timeZone).toInstant(), this.fmtStr);
            this.output.set(res);
            return this.output;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "date_format";
    }
}

