/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public abstract class GenericUDFBaseNwayCompare
extends GenericUDF {
    protected transient ObjectInspector[] argumentOIs;
    protected transient ObjectInspectorConverters.Converter[] converters;
    protected transient ObjectInspector resultOI;

    abstract int getOrder();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException(this.getFuncName() + " requires at least 2 arguments, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException(this.getFuncName() + " only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.argumentOIs = arguments;
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        TypeInfo commonInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[0]);
        for (i = 1; i < arguments.length; ++i) {
            PrimitiveTypeInfo currInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector(arguments[i]);
            commonInfo = FunctionRegistry.getCommonClassForComparison((TypeInfo)commonInfo, (TypeInfo)currInfo);
        }
        this.resultOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(commonInfo == null ? TypeInfoFactory.doubleTypeInfo : commonInfo);
        for (i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter(arguments[i], this.resultOI);
        }
        return this.resultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object maxV = null;
        for (int i = 0; i < arguments.length; ++i) {
            Object ai = arguments[i].get();
            if (ai == null) {
                return null;
            }
            if (maxV == null) {
                maxV = this.converters[i].convert(ai);
                continue;
            }
            Object converted = this.converters[i].convert(ai);
            if (converted == null) {
                return null;
            }
            int result = ObjectInspectorUtils.compare(converted, this.resultOI, maxV, this.resultOI);
            if (this.getOrder() * result <= 0) continue;
            maxV = converted;
        }
        return maxV;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children, ",");
    }
}

