/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRank;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;

@Description(name="dense_rank", value="_FUNC_(x) The difference between RANK and DENSE_RANK is that DENSE_RANK leaves no gaps in ranking sequence when there are ties. That is, if you were ranking a competition using DENSE_RANK and had three people tie for second place, you would say that all three were in second place and that the next person came in third.")
@WindowFunctionDescription(supportsWindow=false, pivotResult=true, rankingFunction=true, orderedAggregate=true)
public class GenericUDAFDenseRank
extends GenericUDAFRank {
    @Override
    protected GenericUDAFRank.GenericUDAFAbstractRankEvaluator createWindowingEvaluator() {
        return new GenericUDAFDenseRankEvaluator();
    }

    @Override
    protected GenericUDAFRank.GenericUDAFHypotheticalSetRankEvaluator createHypotheticalSetEvaluator() {
        return new GenericUDAFHypotheticalSetDenseRankEvaluator();
    }

    public static class GenericUDAFHypotheticalSetDenseRankEvaluator
    extends GenericUDAFRank.GenericUDAFHypotheticalSetRankEvaluator {
        public GenericUDAFHypotheticalSetDenseRankEvaluator() {
            super(false, PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        }

        @Override
        protected void initPartial2AndFinalOI(ObjectInspector[] parameters) {
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new HypotheticalSetDenseRankBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HypotheticalSetDenseRankBuffer rankBuffer = (HypotheticalSetDenseRankBuffer)agg;
            rankBuffer.elements.clear();
            rankBuffer.rank = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            HypotheticalSetDenseRankBuffer rankBuffer = (HypotheticalSetDenseRankBuffer)agg;
            GenericUDAFRank.GenericUDAFHypotheticalSetRankEvaluator.CompareResult compareResult = this.compare(parameters);
            if (compareResult.getCompareResult() == 0) {
                return;
            }
            if (compareResult.getOrder() == 1 && compareResult.getCompareResult() < 0 || compareResult.getOrder() == 0 && compareResult.getCompareResult() > 0) {
                ArrayList<Object> columnValues = new ArrayList<Object>(parameters.length / 4);
                for (int i = 0; i < parameters.length / 4; ++i) {
                    columnValues.add(parameters[i * 4 + 1]);
                }
                RowData rowData = new RowData(columnValues);
                if (!rankBuffer.elements.contains(rowData)) {
                    rankBuffer.elements.add(rowData);
                    rankBuffer.rank++;
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HypotheticalSetDenseRankBuffer rankBuffer = (HypotheticalSetDenseRankBuffer)agg;
            return new LongWritable(rankBuffer.rank + 1L);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            HypotheticalSetDenseRankBuffer rankBuffer;
            if (partial == null) {
                return;
            }
            HypotheticalSetDenseRankBuffer hypotheticalSetDenseRankBuffer = rankBuffer = (HypotheticalSetDenseRankBuffer)agg;
            hypotheticalSetDenseRankBuffer.rank = hypotheticalSetDenseRankBuffer.rank + (((LongWritable)partial).get() - 1L);
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HypotheticalSetDenseRankBuffer rankBuffer = (HypotheticalSetDenseRankBuffer)agg;
            return new LongWritable(rankBuffer.rank + 1L);
        }

        private static class HypotheticalSetDenseRankBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            protected Set<RowData> elements = new HashSet<RowData>();
            private long rank = 0L;

            private HypotheticalSetDenseRankBuffer() {
            }
        }

        private static final class RowData {
            private final List<Object> columnValues;

            private RowData(List<Object> columnValues) {
                this.columnValues = columnValues;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RowData rowData = (RowData)o;
                return Objects.equals(this.columnValues, rowData.columnValues);
            }

            public int hashCode() {
                return Objects.hash(this.columnValues);
            }
        }
    }

    public static class GenericUDAFDenseRankEvaluator
    extends GenericUDAFRank.GenericUDAFRankEvaluator {
        @Override
        protected void nextRank(GenericUDAFRank.RankBuffer rb) {
            ++rb.currentRank;
        }
    }
}

