/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri.serde;

import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.JsonReader;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

class HiveJsonParserReader
implements JsonReader {
    private JsonParser m_jsonParser;

    public HiveJsonParserReader(JsonParser jsonParser) {
        this.m_jsonParser = jsonParser;
    }

    public static JsonReader createFromString(String str) {
        try {
            JsonFactory factory = new JsonFactory();
            JsonParser jsonParser = factory.createParser(str);
            jsonParser.nextToken();
            return new JsonParserReader(jsonParser);
        }
        catch (Exception var3) {
            throw new JsonGeometryException(var3.getMessage());
        }
    }

    public static JsonReader createFromStringNNT(String str) {
        try {
            JsonFactory factory = new JsonFactory();
            JsonParser jsonParser = factory.createParser(str);
            return new JsonParserReader(jsonParser);
        }
        catch (Exception var3) {
            throw new JsonGeometryException(var3.getMessage());
        }
    }

    private static JsonReader.Token mapToken(JsonToken token) {
        if (token == JsonToken.END_ARRAY) {
            return JsonReader.Token.END_ARRAY;
        }
        if (token == JsonToken.END_OBJECT) {
            return JsonReader.Token.END_OBJECT;
        }
        if (token == JsonToken.FIELD_NAME) {
            return JsonReader.Token.FIELD_NAME;
        }
        if (token == JsonToken.START_ARRAY) {
            return JsonReader.Token.START_ARRAY;
        }
        if (token == JsonToken.START_OBJECT) {
            return JsonReader.Token.START_OBJECT;
        }
        if (token == JsonToken.VALUE_FALSE) {
            return JsonReader.Token.VALUE_FALSE;
        }
        if (token == JsonToken.VALUE_NULL) {
            return JsonReader.Token.VALUE_NULL;
        }
        if (token == JsonToken.VALUE_NUMBER_FLOAT) {
            return JsonReader.Token.VALUE_NUMBER_FLOAT;
        }
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return JsonReader.Token.VALUE_NUMBER_INT;
        }
        if (token == JsonToken.VALUE_STRING) {
            return JsonReader.Token.VALUE_STRING;
        }
        if (token == JsonToken.VALUE_TRUE) {
            return JsonReader.Token.VALUE_TRUE;
        }
        if (token == null) {
            return null;
        }
        throw new JsonGeometryException("unexpected token");
    }

    @Override
    public JsonReader.Token nextToken() throws JsonGeometryException {
        try {
            JsonToken token = this.m_jsonParser.nextToken();
            return HiveJsonParserReader.mapToken(token);
        }
        catch (Exception var2) {
            throw new JsonGeometryException(var2);
        }
    }

    @Override
    public JsonReader.Token currentToken() throws JsonGeometryException {
        try {
            return HiveJsonParserReader.mapToken(this.m_jsonParser.getCurrentToken());
        }
        catch (Exception var2) {
            throw new JsonGeometryException(var2);
        }
    }

    @Override
    public void skipChildren() throws JsonGeometryException {
        try {
            this.m_jsonParser.skipChildren();
        }
        catch (Exception var2) {
            throw new JsonGeometryException(var2);
        }
    }

    @Override
    public String currentString() throws JsonGeometryException {
        try {
            return this.m_jsonParser.getText();
        }
        catch (Exception var2) {
            throw new JsonGeometryException(var2);
        }
    }

    @Override
    public double currentDoubleValue() throws JsonGeometryException {
        try {
            return this.m_jsonParser.getValueAsDouble();
        }
        catch (Exception var2) {
            throw new JsonGeometryException(var2);
        }
    }

    @Override
    public int currentIntValue() throws JsonGeometryException {
        try {
            return this.m_jsonParser.getValueAsInt();
        }
        catch (Exception var2) {
            throw new JsonGeometryException(var2);
        }
    }

    @Override
    public boolean currentBooleanValue() {
        JsonReader.Token t = this.currentToken();
        if (t == JsonReader.Token.VALUE_TRUE) {
            return true;
        }
        if (t == JsonReader.Token.VALUE_FALSE) {
            return false;
        }
        throw new JsonGeometryException("Not a boolean");
    }
}

