/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_Polygon", value="_FUNC_(x, y, [x, y]*) - constructor for 2D polygon\n_FUNC_('polygon( ... )') - constructor for 2D polygon", extended="Example:\n  SELECT _FUNC_(1, 1, 1, 4, 4, 4, 4, 1) from src LIMIT 1;  -- creates a rectangle\n  SELECT _FUNC_('polygon ((1 1, 4 1, 1 4))') from src LIMIT 1;  -- creates a triangle")
public class ST_Polygon
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_Polygon.class.getName());

    public BytesWritable evaluate(DoubleWritable ... xyPairs) throws UDFArgumentLengthException {
        if (xyPairs == null || xyPairs.length < 6 || xyPairs.length % 2 != 0) {
            LogUtils.Log_VariableArgumentLengthXY(LOG);
            return null;
        }
        try {
            int i;
            double xStart = xyPairs[0].get();
            double yStart = xyPairs[1].get();
            String wkt = "polygon((" + xStart + " " + yStart;
            for (i = 2; i < xyPairs.length; i += 2) {
                wkt = wkt + ", " + (Object)((Object)xyPairs[i]) + " " + (Object)((Object)xyPairs[i + 1]);
            }
            double xEnd = xyPairs[i - 2].get();
            double yEnd = xyPairs[i - 1].get();
            if (xEnd != xStart || yEnd != yStart) {
                wkt = wkt + ", " + xStart + " " + yStart;
            }
            wkt = wkt + "))";
            return this.evaluate(new Text(wkt));
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_Polygon: " + e);
            return null;
        }
    }

    public BytesWritable evaluate(Text wkwrap) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            OGCGeometry ogcObj = OGCGeometry.fromText(wkt);
            ogcObj.setSpatialReference(null);
            if (ogcObj.geometryType().equals("Polygon")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_POLYGON, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

