/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_MultiPoint", value="_FUNC_(x1, y1, x2, y2, x3, y3) - constructor for 2D multipoint\n_FUNC_('multipoint( ... )') - constructor for 2D multipoint", extended="Example:\n  SELECT _FUNC_(1, 1, 2, 2, 3, 3) from src LIMIT 1; -- multipoint with 3 points\n  SELECT _FUNC_('MULTIPOINT ((10 40), (40 30))') from src LIMIT 1; -- multipoint of 2 points")
public class ST_MultiPoint
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_MultiPoint.class.getName());

    public BytesWritable evaluate(DoubleWritable ... xyPairs) throws UDFArgumentLengthException {
        if (xyPairs == null || xyPairs.length == 0 || xyPairs.length % 2 != 0) {
            LogUtils.Log_VariableArgumentLengthXY(LOG);
            return null;
        }
        try {
            MultiPoint mPoint = new MultiPoint();
            for (int i = 0; i < xyPairs.length; i += 2) {
                mPoint.add(xyPairs[i].get(), xyPairs[i + 1].get());
            }
            return GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry(mPoint, null, true));
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_MultiPoint: " + e);
            return null;
        }
    }

    public BytesWritable evaluate(Text wkwrap) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            OGCGeometry ogcObj = OGCGeometry.fromText(wkt);
            ogcObj.setSpatialReference(null);
            if (ogcObj.geometryType().equals("MultiPoint")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_MULTIPOINT, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

