/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_AsShape", value="_FUNC_(ST_Geometry) - return Esri shape representation of geometry\n", extended="Example:\n  SELECT _FUNC_(ST_Point(1, 2)) FROM onerow; -- Esri shape representation of POINT (1 2)\n")
public class ST_AsShape
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_AsShape.class.getName());

    public BytesWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            Geometry esriGeometry = ogcGeometry.getEsriGeometry();
            byte[] esriShape = GeometryEngine.geometryToEsriShape(esriGeometry);
            return new BytesWritable(esriShape);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }
}

