/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_Aggr_Intersection", value="_FUNC_(ST_Geometry) - aggregate intersection of all geometries passed", extended="Example:\n  SELECT _FUNC_(geometry) FROM source; -- return intersection of all geometries in source")
public class ST_Aggr_Intersection
extends UDAF {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_Aggr_Intersection.class.getName());

    public static class AggrIntersectionBinaryEvaluator
    implements UDAFEvaluator {
        private OGCGeometry isectGeom = null;
        SpatialReference spatialRef = null;
        int firstWKID = -2;

        public void init() {
        }

        public boolean iterate(BytesWritable geomref) throws HiveException {
            if (geomref == null) {
                LogUtils.Log_ArgumentsNull(LOG);
                return false;
            }
            if (this.firstWKID == -2) {
                this.firstWKID = GeometryUtils.getWKID(geomref);
                if (this.firstWKID != 0) {
                    this.spatialRef = SpatialReference.create(this.firstWKID);
                }
            } else if (this.firstWKID != GeometryUtils.getWKID(geomref)) {
                LogUtils.Log_SRIDMismatch(LOG, geomref, this.firstWKID);
                return false;
            }
            try {
                OGCGeometry rowGeom = GeometryUtils.geometryFromEsriShape(geomref);
                rowGeom.setSpatialReference(this.spatialRef);
                this.isectGeom = this.isectGeom == null ? rowGeom : this.isectGeom.intersection(rowGeom);
                return true;
            }
            catch (Exception e) {
                LogUtils.Log_InternalError(LOG, "ST_Aggr_Intersection: " + e);
                return false;
            }
        }

        public boolean merge(BytesWritable other) throws HiveException {
            return this.iterate(other);
        }

        public BytesWritable terminatePartial() throws HiveException {
            if (this.isectGeom == null) {
                return null;
            }
            return GeometryUtils.geometryToEsriShapeBytesWritable(this.isectGeom);
        }

        public BytesWritable terminate() throws HiveException {
            return this.terminatePartial();
        }
    }
}

