/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToFloat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToFloat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToFloatViaLongToDouble;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastTimestampToDouble.class, CastLongToFloatViaLongToDouble.class, CastDecimalToFloat.class, CastStringToFloat.class})
@Description(name="float", value="_FUNC_(x) - converts it's parameter to _FUNC_", extended="- x is NULL -> NULL\n- byte, short, integer, long, float, double, decimal, timestamp:\n  x fits into the type _FUNC_ -> x\n  undefined otherwise\n- boolean:\n  true  -> 1.0\n  false -> 0.0\n- string:\n  x is a valid _FUNC_ -> x\n  NULL otherwise\nExample:\n   > SELECT _FUNC_(true);\n  1.0")
public class UDFToFloat
extends UDF {
    private final FloatWritable floatWritable = new FloatWritable();

    public FloatWritable evaluate(NullWritable i) {
        return null;
    }

    public FloatWritable evaluate(BooleanWritable i) {
        if (i == null) {
            return null;
        }
        this.floatWritable.set(i.get() ? 1.0f : 0.0f);
        return this.floatWritable;
    }

    public FloatWritable evaluate(ByteWritable i) {
        if (i == null) {
            return null;
        }
        this.floatWritable.set((float)i.get());
        return this.floatWritable;
    }

    public FloatWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.floatWritable.set((float)i.get());
        return this.floatWritable;
    }

    public FloatWritable evaluate(IntWritable i) {
        if (i == null) {
            return null;
        }
        this.floatWritable.set((float)i.get());
        return this.floatWritable;
    }

    public FloatWritable evaluate(LongWritable i) {
        if (i == null) {
            return null;
        }
        this.floatWritable.set((float)i.get());
        return this.floatWritable;
    }

    public FloatWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.floatWritable.set((float)i.get());
        return this.floatWritable;
    }

    public FloatWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        if (!LazyUtils.isNumberMaybe(i.getBytes(), 0, i.getLength())) {
            return null;
        }
        try {
            this.floatWritable.set(Float.parseFloat(i.toString()));
            return this.floatWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public FloatWritable evaluate(TimestampWritableV2 i) {
        if (i == null) {
            return null;
        }
        try {
            this.floatWritable.set((float)i.getDouble());
            return this.floatWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public FloatWritable evaluate(HiveDecimalWritable i) {
        if (i == null || !i.isSet()) {
            return null;
        }
        this.floatWritable.set(i.floatValue());
        return this.floatWritable;
    }
}

