/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSConverter;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.GetDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.localcache.HMSPartitionNamesConverter;
import org.apache.hadoop.hive.metastore.localcache.PartitionCacheHelper;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreClientWithLocalCache
extends HiveMetaStoreClient
implements IMetaStoreClient {
    private static final Map<Long, Boolean> OPEN_WRITE_TXNS = new ConcurrentHashMap<Long, Boolean>();
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClientWithLocalCache.class);
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static Cache<CacheKey, Object> mscLocalCache = null;
    private static long maxSize;
    private static boolean recordStats;
    private static HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> sizeEstimator;
    private static String cacheObjName;

    public static synchronized void init(Configuration conf) {
        if (!INITIALIZED.get()) {
            LOG.info("Initializing local cache in HiveMetaStoreClient...");
            maxSize = MetastoreConf.getSizeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSC_CACHE_MAX_SIZE);
            recordStats = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSC_CACHE_RECORD_STATS);
            HiveMetaStoreClientWithLocalCache.initSizeEstimator();
            HiveMetaStoreClientWithLocalCache.initCache();
            LOG.info("Local cache initialized in HiveMetaStoreClient: {}", mscLocalCache);
            INITIALIZED.set(true);
        }
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        super(conf, hookLoader, allowEmbedded);
    }

    private static void initSizeEstimator() {
        sizeEstimator = new HashMap();
        IncrementalObjectSizeEstimator.createEstimators(CacheKey.class, sizeEstimator);
        for (KeyType e : KeyType.values()) {
            for (Class c : e.keyClasses) {
                IncrementalObjectSizeEstimator.createEstimators((Object)c, sizeEstimator);
            }
            IncrementalObjectSizeEstimator.createEstimators((Object)e.valueClass, sizeEstimator);
        }
    }

    private static int getWeight(CacheKey key, Object val) {
        IncrementalObjectSizeEstimator.ObjectEstimator keySizeEstimator = sizeEstimator.get(key.getClass());
        IncrementalObjectSizeEstimator.ObjectEstimator valSizeEstimator = sizeEstimator.get(key.IDENTIFIER.valueClass);
        int keySize = keySizeEstimator.estimate((Object)key, sizeEstimator);
        int valSize = valSizeEstimator.estimate(val, sizeEstimator);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache entry weight - key: {}, value: {}, total: {}", new Object[]{keySize, valSize, keySize + valSize});
        }
        return keySize + valSize;
    }

    private static void initCache() {
        int initSize = 100;
        Caffeine cacheBuilder = Caffeine.newBuilder().initialCapacity(initSize).maximumWeight(maxSize).weigher(HiveMetaStoreClientWithLocalCache::getWeight).removalListener((key, val, cause) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caffeine - ({}, {}) was removed ({})", new Object[]{key, val, cause});
            }
        });
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        mscLocalCache = cacheBuilder.build();
        cacheObjName = cacheBuilder.toString();
    }

    protected GetTableResult getTableInternal(GetTableRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(req.getValidWriteIdList(), req.getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDbName(), req.getTblName());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.TABLE, req.getDbName(), req.getTblName(), watermark, req.isGetFileMetadata(), req.getEngine(), req.isGetColumnStats(), req.getId());
            GetTableResult r = (GetTableResult)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = this.convertTableRequest(req, super.getTableInternal(req));
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getTableInternal, dbName={}, tblName={}, columnStats={}, fileMetadata={}", new Object[]{req.getDbName(), req.getTblName(), req.isGetColumnStats(), req.isGetFileMetadata()});
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return this.convertTableRequest(req, super.getTableInternal(req));
    }

    protected PartitionsByExprResult getPartitionsByExprInternal(PartitionsByExprRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(req.getValidWriteIdList(), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDbName(), req.getTblName());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.PARTITIONS_BY_EXPR, watermark, req);
            PartitionsByExprResult r = (PartitionsByExprResult)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getPartitionsByExprInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getPartitionsByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getPartitionsByExprInternal(req);
    }

    protected GetPartitionNamesPsResponse listPartitionNamesRequestInternal(GetPartitionNamesPsRequest request) throws TException {
        GetPartitionNamesPsResponse r;
        HMSPartitionNamesConverter converter;
        if (this.isCacheEnabledAndInitialized()) {
            String catName = request.getCatName();
            String dbName = request.getDbName();
            String tableName = request.getTblName();
            short maxParts = request.getMaxParts();
            List partValues = request.getPartValues();
            String validWriteIdList = this.getValidWriteIdList(dbName, tableName);
            TableWatermark watermark = new TableWatermark(validWriteIdList, this.getTable(dbName, tableName).getId());
            if (watermark.isValid()) {
                HMSPartitionNamesConverter converter2;
                boolean isInCache;
                Long txnId = this.getTxnId(dbName, tableName);
                CacheKey cacheKey = CacheKey.create(txnId, KeyType.LIST_PARTITIONS_REQ, watermark, catName, dbName, tableName, (int)maxParts, partValues);
                GetPartitionNamesPsResponse r2 = (GetPartitionNamesPsResponse)mscLocalCache.getIfPresent((Object)cacheKey);
                boolean bl = isInCache = r2 != null;
                if (!isInCache) {
                    r2 = super.listPartitionNamesRequestInternal(request);
                }
                if ((converter2 = this.getPartitionNamesConverter(request, r2)) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HS2 level HMS conversion needed: method=listPartitionNamesInternal, dbName={}, tblName={}", (Object)dbName, (Object)tableName);
                    }
                    r2 = converter2.convertPartitionNames(r2);
                }
                if (!isInCache || converter2 != null) {
                    mscLocalCache.put((Object)cacheKey, (Object)r2);
                } else {
                    LOG.debug("HS2 level HMS cache: method=listPartitionNamesInternal, dbName={}, tblName={}", (Object)dbName, (Object)tableName);
                }
                if (LOG.isDebugEnabled() && recordStats) {
                    LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
                }
                return r2;
            }
        }
        return (converter = this.getPartitionNamesConverter(request, r = super.listPartitionNamesRequestInternal(request))) == null ? r : converter.convertPartitionNames(r);
    }

    protected List<String> listPartitionNamesInternal(String catName, String dbName, String tableName, int maxParts) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(dbName, tableName), this.getTable(dbName, tableName).getId())).isValid()) {
            Long txnId = this.getTxnId(dbName, tableName);
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.LIST_PARTITIONS_ALL, watermark, catName, dbName, tableName, maxParts);
            PartitionNamesWrapper r = (PartitionNamesWrapper)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = new PartitionNamesWrapper(super.listPartitionNamesInternal(catName, dbName, tableName, maxParts));
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=listPartitionNamesInternal, dbName={}, tblName={}", (Object)dbName, (Object)tableName);
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r.partitionNames;
        }
        return super.listPartitionNamesInternal(catName, dbName, tableName, maxParts);
    }

    protected PrimaryKeysResponse getPrimaryKeysInternal(PrimaryKeysRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDb_name(), req.getTbl_name()), this.getTable(req.getDb_name(), req.getTbl_name()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDb_name(), req.getTbl_name());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.PRIMARY_KEYS, watermark, req);
            PrimaryKeysResponse r = (PrimaryKeysResponse)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getPrimaryKeysInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getPrimaryKeysInternal, dbName={}, tblName={}", (Object)req.getDb_name(), (Object)req.getTbl_name());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getPrimaryKeysInternal(req);
    }

    protected ForeignKeysResponse getForeignKeysInternal(ForeignKeysRequest req) throws TException {
        String foreign_tbl_name;
        String foreign_db_name;
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(foreign_db_name = req.getForeign_db_name() != null ? req.getForeign_db_name() : req.getParent_db_name(), foreign_tbl_name = req.getForeign_tbl_name() != null ? req.getForeign_tbl_name() : req.getParent_tbl_name()), this.getTable(foreign_db_name, foreign_tbl_name).getId())).isValid()) {
            Long txnId = this.getTxnId(foreign_db_name, foreign_tbl_name);
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.FOREIGN_KEYS, watermark, req);
            ForeignKeysResponse r = (ForeignKeysResponse)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getForeignKeysInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getForeignKeysInternal, dbName={}, tblName={}", (Object)req.getForeign_db_name(), (Object)req.getForeign_tbl_name());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getForeignKeysInternal(req);
    }

    protected UniqueConstraintsResponse getUniqueConstraintsInternal(UniqueConstraintsRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDb_name(), req.getTbl_name()), this.getTable(req.getDb_name(), req.getTbl_name()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDb_name(), req.getTbl_name());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.UNIQUE_CONSTRAINTS, watermark, req);
            UniqueConstraintsResponse r = (UniqueConstraintsResponse)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getUniqueConstraintsInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getUniqueConstraintsInternal, dbName={}, tblName={}", (Object)req.getDb_name(), (Object)req.getTbl_name());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getUniqueConstraintsInternal(req);
    }

    protected NotNullConstraintsResponse getNotNullConstraintsInternal(NotNullConstraintsRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDb_name(), req.getTbl_name()), this.getTable(req.getDb_name(), req.getTbl_name()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDb_name(), req.getTbl_name());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.NOT_NULL_CONSTRAINTS, watermark, req);
            NotNullConstraintsResponse r = (NotNullConstraintsResponse)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getNotNullConstraintsInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getNotNullConstraintsInternal, dbName={}, tblName={}", (Object)req.getDb_name(), (Object)req.getTbl_name());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getNotNullConstraintsInternal(req);
    }

    protected AllTableConstraintsResponse getAllTableConstraintsInternal(AllTableConstraintsRequest req) throws MetaException, TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDbName(), req.getTblName()), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDbName(), req.getTblName());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.ALL_TABLE_CONSTRAINTS, watermark, req);
            AllTableConstraintsResponse r = (AllTableConstraintsResponse)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getAllTableConstraintsInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getAllTableConstraintsInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r.deepCopy();
        }
        return super.getAllTableConstraintsInternal(req);
    }

    protected TableStatsResult getTableColumnStatisticsInternal(TableStatsRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(this.getValidWriteIdList(req.getDbName(), req.getTblName()), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDbName(), req.getTblName());
            CacheWrapper cache = new CacheWrapper(mscLocalCache);
            ArrayList<String> columnNamesMissing = new ArrayList<String>();
            ArrayList<ColumnStatisticsObj> columnStatsFound = new ArrayList<ColumnStatisticsObj>();
            this.getTableColumnStatisticsCache(txnId, cache, req, watermark, columnNamesMissing, columnStatsFound);
            if (columnNamesMissing.isEmpty()) {
                return new TableStatsResult(columnStatsFound);
            }
            TableStatsRequest newRqst = new TableStatsRequest(req);
            newRqst.setColNames(columnNamesMissing);
            TableStatsResult r = super.getTableColumnStatisticsInternal(newRqst);
            ArrayList<ColumnStatisticsObj> newColumnStats = new ArrayList<ColumnStatisticsObj>();
            this.loadTableColumnStatisticsCache(txnId, cache, r, req, watermark, newColumnStats);
            TableStatsResult result = this.computeTableColumnStatisticsFinal(req, columnStatsFound, newColumnStats);
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return result;
        }
        return super.getTableColumnStatisticsInternal(req);
    }

    protected AggrStats getAggrStatsForInternal(PartitionsStatsRequest req) throws TException {
        TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(req.getValidWriteIdList(), this.getTable(req.getDbName(), req.getTblName()).getId())).isValid()) {
            Long txnId = this.getTxnId(req.getDbName(), req.getTblName());
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.AGGR_COL_STATS, watermark, req);
            AggrStats r = (AggrStats)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = super.getAggrStatsForInternal(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HS2 level HMS cache: method=getAggrStatsForInternal, dbName={}, tblName={}, partNames={}", new Object[]{req.getDbName(), req.getTblName(), req.getPartNames()});
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return super.getAggrStatsForInternal(req);
    }

    protected GetPartitionsByNamesResult getPartitionsByNamesInternal(GetPartitionsByNamesRequest rqst) throws TException {
        TableWatermark watermark;
        String dbName = MetaStoreUtils.parseDbName((String)rqst.getDb_name(), (Configuration)this.conf)[1];
        Table table = this.getTable(dbName, rqst.getTbl_name());
        if (this.isCacheEnabledAndInitialized() && (watermark = new TableWatermark(rqst.getValidWriteIdList(), table.getId())).isValid()) {
            Long txnId = this.getTxnId(dbName, rqst.getTbl_name());
            CacheKey key = CacheKey.create(txnId, KeyType.PARTITIONS_BY_NAMES, rqst.getDb_name(), rqst.getTbl_name(), watermark, rqst.isGetFileMetadata());
            PartitionCacheHelper.CacheValue cacheValue = (PartitionCacheHelper.CacheValue)mscLocalCache.get((Object)key, k -> PartitionCacheHelper.createCacheValue((GetPartitionsByNamesRequest)rqst, (HMSConverter)this.getHMSConverter(), (Table)table, (boolean)true));
            PartitionCacheHelper cacheHelper = new PartitionCacheHelper(cacheValue, rqst, this.getHMSConverter(), table, PartitionCacheHelper.Level.HS2);
            if (!cacheHelper.cacheContainsAllPartitions()) {
                GetPartitionsByNamesRequest missingNamesRqst = cacheHelper.getMissingNamesRequest();
                GetPartitionsByNamesResult missingNamesResult = super.getPartitionsByNamesInternal(missingNamesRqst);
                cacheHelper.addToCache(missingNamesRqst, missingNamesResult, cacheValue);
                if (LOG.isDebugEnabled() && recordStats) {
                    LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
                }
            }
            return cacheHelper.fetchRequestedResultFromCache(cacheValue);
        }
        GetPartitionsByNamesResult requestedResult = super.getPartitionsByNamesInternal(rqst);
        PartitionCacheHelper cacheHelper = new PartitionCacheHelper(rqst, this.getHMSConverter(), table, PartitionCacheHelper.Level.HS2);
        return cacheHelper.fetchRequestedResult(requestedResult);
    }

    private boolean isCacheEnabledAndInitialized() {
        SessionState sessionState = SessionState.get();
        if (sessionState == null || sessionState.getQueryCache(this.getQueryId()) == null) {
            return false;
        }
        return INITIALIZED.get();
    }

    protected String getQueryId() {
        try {
            return Hive.get().getConf().get(HiveConf.ConfVars.HIVEQUERYID.varname);
        }
        catch (HiveException e) {
            LOG.error("Error getting query id. Query level and Global HMS caching will be disabled", (Throwable)e);
            return null;
        }
    }

    protected final void getTableColumnStatisticsCache(Long txnId, CacheI cache, TableStatsRequest rqst, TableWatermark watermark, List<String> columnNamesMissing, List<ColumnStatisticsObj> columnStatsFound) {
        CacheKey cacheKey = CacheKey.create(txnId, KeyType.TABLE_COLUMN_STATS, watermark, rqst.getDbName(), rqst.getTblName());
        Map cacheValue = (Map)cache.get(cacheKey);
        if (cacheValue == null) {
            columnNamesMissing.addAll(rqst.getColNames());
            return;
        }
        ArrayList<String> columnNamesFound = new ArrayList<String>();
        for (String colName : rqst.getColNames()) {
            ColumnStatisticsObj cachedColStats = (ColumnStatisticsObj)cacheValue.get(colName);
            if (cachedColStats == null) {
                columnNamesMissing.add(colName);
                continue;
            }
            columnStatsFound.add(cachedColStats);
            columnNamesFound.add(colName);
        }
        if (columnNamesFound.size() > 0 && LOG.isDebugEnabled()) {
            if (watermark == null) {
                LOG.debug("Query level HMS cache: method=getTableColumnStatisticsInternal, dbName={}, tblName={}, columnNames={}", new Object[]{rqst.getDbName(), rqst.getTblName(), columnNamesFound});
            } else {
                LOG.debug("HS2 level HMS cache: method=getTableColumnStatisticsInternal, dbName={}, tblName={}, columnNames={}", new Object[]{rqst.getDbName(), rqst.getTblName(), columnNamesFound});
            }
        }
    }

    protected final void loadTableColumnStatisticsCache(Long txnId, CacheI cache, TableStatsResult r, TableStatsRequest rqst, TableWatermark watermark, List<ColumnStatisticsObj> newColumnStats) {
        ConcurrentHashMap<String, ColumnStatisticsObj> cacheValue;
        CacheKey cacheKey = CacheKey.create(txnId, KeyType.TABLE_COLUMN_STATS, watermark, rqst.getDbName(), rqst.getTblName());
        if (cache instanceof CacheWrapper) {
            cacheValue = (Map)((CacheWrapper)cache).cache.get((Object)cacheKey, k -> new ConcurrentHashMap());
        } else {
            cacheValue = (ConcurrentHashMap<String, ColumnStatisticsObj>)cache.get(cacheKey);
            if (cacheValue == null) {
                cacheValue = new ConcurrentHashMap<String, ColumnStatisticsObj>();
                cache.put(cacheKey, cacheValue);
            }
        }
        for (ColumnStatisticsObj colStat : r.getTableStats()) {
            cacheValue.put(colStat.getColName(), colStat);
            newColumnStats.add(colStat);
        }
    }

    protected final TableStatsResult computeTableColumnStatisticsFinal(TableStatsRequest rqst, List<ColumnStatisticsObj> colStats, List<ColumnStatisticsObj> newColStats) {
        ArrayList<ColumnStatisticsObj> result = new ArrayList<ColumnStatisticsObj>();
        int i = 0;
        int j = 0;
        for (String colName : rqst.getColNames()) {
            if (i >= colStats.size() || j >= newColStats.size()) break;
            if (colStats.get(i).getColName().equals(colName)) {
                result.add(colStats.get(i));
                ++i;
                continue;
            }
            if (!newColStats.get(j).getColName().equals(colName)) continue;
            result.add(newColStats.get(j));
            ++j;
        }
        while (i < colStats.size()) {
            result.add(colStats.get(i));
            ++i;
        }
        while (j < newColStats.size()) {
            result.add(newColStats.get(j));
            ++j;
        }
        return new TableStatsResult(result);
    }

    protected HMSConverter getHMSConverter() {
        return null;
    }

    private HMSPartitionNamesConverter getPartitionNamesConverter(GetPartitionNamesPsRequest request, GetPartitionNamesPsResponse result) throws MetaException {
        if (this.getHMSConverter() == null) {
            return null;
        }
        return this.getHMSConverter().getPartitionNamesConverter(request, result);
    }

    protected final GetTableResult convertTableRequest(GetTableRequest rqst, GetTableResult result) {
        if (this.getHMSConverter() == null || this.getHMSConverter().getTableConverter(rqst) == null) {
            return result;
        }
        return this.getHMSConverter().getTableConverter(rqst).convertTable(result);
    }

    protected final Pair<List<TableValidWriteIds>, List<String>> getValidWriteIdsCache(Long txnId, CacheI cache, GetValidWriteIdsRequest rqst) throws TException {
        ArrayList<String> fullTableNamesMissing = new ArrayList<String>();
        ArrayList<TableValidWriteIds> tblValidWriteIds = new ArrayList<TableValidWriteIds>();
        for (String fullTableName : rqst.getFullTableNames()) {
            CacheKey cacheKey = CacheKey.create(KeyType.VALID_WRITE_IDS, fullTableName, rqst.getValidTxnList(), rqst.getWriteId());
            TableValidWriteIds v = (TableValidWriteIds)cache.get(cacheKey);
            if (v == null) {
                fullTableNamesMissing.add(fullTableName);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Query level HMS cache: method=getValidWriteIdsInternal, fullTableName={}", (Object)fullTableName);
            }
            tblValidWriteIds.add(v);
        }
        return Pair.of(tblValidWriteIds, fullTableNamesMissing);
    }

    protected final List<TableValidWriteIds> loadValidWriteIdsCache(Long txnId, CacheI cache, GetValidWriteIdsResponse r, GetValidWriteIdsRequest rqst) throws TException {
        ArrayList<TableValidWriteIds> newTblValidWriteIds = new ArrayList<TableValidWriteIds>();
        for (TableValidWriteIds tableValidWriteIds : r.getTblValidWriteIds()) {
            newTblValidWriteIds.add(tableValidWriteIds);
            CacheKey cacheKey = CacheKey.create(txnId, KeyType.VALID_WRITE_IDS, tableValidWriteIds.getFullTableName(), rqst.getValidTxnList(), rqst.getWriteId());
            cache.put(cacheKey, tableValidWriteIds);
        }
        return newTblValidWriteIds;
    }

    protected final GetValidWriteIdsResponse computeValidWriteIdsFinal(GetValidWriteIdsRequest rqst, List<TableValidWriteIds> tblValidWriteIds, List<TableValidWriteIds> newTblValidWriteIds) {
        ArrayList<TableValidWriteIds> result = new ArrayList<TableValidWriteIds>();
        int i = 0;
        int j = 0;
        for (String fullTableName : rqst.getFullTableNames()) {
            if (i >= tblValidWriteIds.size() || j >= newTblValidWriteIds.size()) break;
            if (tblValidWriteIds.get(i).getFullTableName().equals(fullTableName)) {
                result.add(tblValidWriteIds.get(i));
                ++i;
                continue;
            }
            if (!newTblValidWriteIds.get(j).getFullTableName().equals(fullTableName)) continue;
            result.add(newTblValidWriteIds.get(j));
            ++j;
        }
        while (i < tblValidWriteIds.size()) {
            result.add(tblValidWriteIds.get(i));
            ++i;
        }
        while (j < newTblValidWriteIds.size()) {
            result.add(newTblValidWriteIds.get(j));
            ++j;
        }
        return new GetValidWriteIdsResponse(result);
    }

    protected List<TxnToWriteId> allocateTableWriteIdsBatchIntr(AllocateTableWriteIdsRequest rqst) throws TException {
        List txnToWriteIds = super.allocateTableWriteIdsBatchIntr(rqst);
        if (rqst.getTxnIds() != null) {
            for (Long txnId : rqst.getTxnIds()) {
                OPEN_WRITE_TXNS.put(txnId, true);
            }
        }
        return txnToWriteIds;
    }

    public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
        try {
            super.rollbackTxn(txnid);
        }
        finally {
            CacheKey.clearTransactionInfo(txnid, OPEN_WRITE_TXNS.containsKey(txnid));
            OPEN_WRITE_TXNS.remove(txnid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replRollbackTxn(long srcTxnId, String replPolicy, TxnType txnType) throws NoSuchTxnException, TException {
        try {
            super.replRollbackTxn(srcTxnId, replPolicy, txnType);
        }
        finally {
            CacheKey.clearTransactionInfo(srcTxnId, OPEN_WRITE_TXNS.containsKey(srcTxnId));
            OPEN_WRITE_TXNS.remove(srcTxnId);
        }
    }

    public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
        try {
            super.commitTxn(txnid);
        }
        finally {
            CacheKey.clearTransactionInfo(txnid, OPEN_WRITE_TXNS.containsKey(txnid));
            OPEN_WRITE_TXNS.remove(txnid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTxnWithKeyValue(long txnid, long tableId, String key, String value) throws NoSuchTxnException, TxnAbortedException, TException {
        try {
            super.commitTxnWithKeyValue(txnid, tableId, key, value);
        }
        finally {
            CacheKey.clearTransactionInfo(txnid, OPEN_WRITE_TXNS.containsKey(txnid));
            OPEN_WRITE_TXNS.remove(txnid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, TException {
        try {
            super.commitTxn(rqst);
        }
        finally {
            long txnid = rqst.getTxnid();
            CacheKey.clearTransactionInfo(txnid, OPEN_WRITE_TXNS.containsKey(txnid));
            OPEN_WRITE_TXNS.remove(txnid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTxns(List<Long> txnids) throws NoSuchTxnException, TException {
        try {
            super.abortTxns(txnids);
        }
        finally {
            for (Long txnid : txnids) {
                CacheKey.clearTransactionInfo(txnid, OPEN_WRITE_TXNS.containsKey(txnid));
                OPEN_WRITE_TXNS.remove(txnid);
            }
        }
    }

    static {
        sizeEstimator = null;
        cacheObjName = null;
    }

    protected static class TableWatermark {
        final String validWriteIdList;
        final long tableId;

        protected TableWatermark(String validWriteIdList, long tableId) {
            this.validWriteIdList = validWriteIdList;
            this.tableId = tableId;
        }

        public boolean isValid() {
            return this.validWriteIdList != null && this.tableId != -1L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableWatermark that = (TableWatermark)o;
            return this.tableId == that.tableId && Objects.equals(this.validWriteIdList, that.validWriteIdList);
        }

        public int hashCode() {
            return Objects.hash(this.validWriteIdList, this.tableId);
        }

        public String toString() {
            return "TableWatermark {" + this.tableId + " @@ " + (this.validWriteIdList != null ? this.validWriteIdList : "null") + "}";
        }
    }

    protected static interface CacheI {
        public void put(Object var1, Object var2);

        public Object get(Object var1);
    }

    protected static class CacheWrapper
    implements CacheI {
        final Cache<CacheKey, Object> cache;

        protected CacheWrapper(Cache<CacheKey, Object> c) {
            this.cache = c;
        }

        @Override
        public void put(Object k, Object v) {
            this.cache.put((Object)((CacheKey)k), v);
        }

        @Override
        public Object get(Object k) {
            return this.cache.getIfPresent(k);
        }
    }

    private static class PartitionNamesWrapper {
        private final List<String> partitionNames;

        private PartitionNamesWrapper(List<String> partitionNames) {
            this.partitionNames = partitionNames;
        }
    }

    public static class CacheKey {
        private static Map<Long, List<CacheKey>> openTxnCacheKeyMap = new ConcurrentHashMap<Long, List<CacheKey>>();
        KeyType IDENTIFIER;
        List<Object> obj;

        private CacheKey(KeyType IDENTIFIER, Object ... objs) {
            this.IDENTIFIER = IDENTIFIER;
            this.obj = Collections.unmodifiableList(Arrays.asList(objs));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.IDENTIFIER == cacheKey.IDENTIFIER && Objects.equals(this.obj, cacheKey.obj);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.IDENTIFIER, this.obj});
        }

        public String toString() {
            return "CacheKey {" + this.IDENTIFIER.name() + " @@ " + this.obj.toString() + "}";
        }

        public static void clearTransactionInfo(long txnId, boolean removeCacheEntries) {
            if (removeCacheEntries && openTxnCacheKeyMap.containsKey(txnId)) {
                List<CacheKey> cacheKeys = openTxnCacheKeyMap.get(txnId);
                for (CacheKey cacheKey : cacheKeys) {
                    mscLocalCache.invalidate((Object)cacheKey);
                }
            }
            openTxnCacheKeyMap.remove(txnId);
        }

        public static CacheKey create(KeyType IDENTIFIER, Object ... objs) {
            return CacheKey.create(null, IDENTIFIER, objs);
        }

        public static CacheKey create(Long txnId, KeyType IDENTIFIER, Object ... objs) {
            CacheKey cacheKey = new CacheKey(IDENTIFIER, objs);
            if (txnId != null) {
                List cacheKeys = openTxnCacheKeyMap.computeIfAbsent(txnId, k -> new ArrayList());
                cacheKeys.add(cacheKey);
            }
            return cacheKey;
        }
    }

    public static enum KeyType {
        CONFIG_VALUE(String.class, new Class[0]),
        DATABASE(Database.class, GetDatabaseRequest.class),
        TABLE(GetTableResult.class, TableWatermark.class, String.class, Boolean.TYPE, Long.TYPE),
        PRIMARY_KEYS(PrimaryKeysResponse.class, PrimaryKeysRequest.class),
        FOREIGN_KEYS(ForeignKeysResponse.class, ForeignKeysRequest.class),
        UNIQUE_CONSTRAINTS(UniqueConstraintsResponse.class, UniqueConstraintsRequest.class),
        NOT_NULL_CONSTRAINTS(NotNullConstraintsResponse.class, NotNullConstraintsRequest.class),
        ALL_TABLE_CONSTRAINTS(AllTableConstraintsResponse.class, AllTableConstraintsRequest.class),
        TABLE_COLUMN_STATS(ConcurrentHashMap.class, String.class, ColumnStatisticsObj.class, String.class, String.class, TableWatermark.class),
        AGGR_COL_STATS(AggrStats.class, PartitionsStatsRequest.class, TableWatermark.class),
        PARTITIONS_BY_EXPR(PartitionsByExprResult.class, PartitionsByExprRequest.class, TableWatermark.class),
        LIST_PARTITIONS_ALL(PartitionNamesWrapper.class, String.class, Integer.TYPE, TableWatermark.class),
        LIST_PARTITIONS(String.class, Integer.TYPE),
        LIST_PARTITIONS_REQ(GetPartitionNamesPsResponse.class, GetPartitionNamesPsRequest.class),
        LIST_PARTITIONS_AUTH_INFO_ALL(Partition.class, String.class, Integer.TYPE),
        LIST_PARTITIONS_AUTH_INFO(Partition.class, String.class, Integer.TYPE),
        LIST_PARTITIONS_AUTH_INFO_REQ(GetPartitionsPsWithAuthResponse.class, GetPartitionsPsWithAuthRequest.class),
        PARTITIONS_BY_NAMES(PartitionCacheHelper.CacheValue.class, ConcurrentHashMap.class, String.class, Partition.class, String.class, String.class, TableWatermark.class, Boolean.TYPE),
        VALID_WRITE_IDS(TableValidWriteIds.class, String.class, Long.TYPE);

        private final List<Class<?>> keyClasses;
        private final Class<?> valueClass;

        private KeyType(Class<?> valueClass, Class<?> ... keyClasses) {
            this.keyClasses = Collections.unmodifiableList(Arrays.asList(keyClasses));
            this.valueClass = valueClass;
        }
    }
}

