/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class TimestampColSubtractIntervalYearMonthScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final HiveIntervalYearMonth value;
    private final transient DateTimeMath dtm = new DateTimeMath();

    public TimestampColSubtractIntervalYearMonthScalar(int colNum, long value, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.value = new HiveIntervalYearMonth((int)value);
    }

    public TimestampColSubtractIntervalYearMonthScalar() {
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        if (inputColVector1.isRepeating) {
            if (inputColVector1.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.dtm.subtract(inputColVector1.asScratchTimestamp(0), this.value, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchTimestamp());
                        outputColVector.setFromScratchTimestamp(i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchTimestamp());
                        outputColVector.setFromScratchTimestamp(i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + this.value.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"timestamp"), VectorExpressionDescriptor.ArgumentType.getType((String)"interval_year_month")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

