/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterDoubleColLessEqualLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public FilterDoubleColLessEqualLongColumn(int colNum1, int colNum2) {
        super(colNum1, colNum2, -1);
    }

    public FilterDoubleColLessEqualLongColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector1 = (DoubleColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.inputColumnNum[1]];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        double[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        int newSize = NullUtil.filterNulls(batch.cols[this.inputColumnNum[0]], batch.selectedInUse, sel, n);
        if (newSize < n) {
            n = batch.size = newSize;
            batch.selectedInUse = true;
        }
        if ((newSize = NullUtil.filterNulls(batch.cols[this.inputColumnNum[1]], batch.selectedInUse, sel, n)) < n) {
            n = batch.size = newSize;
            batch.selectedInUse = true;
        }
        if (n != 0 && inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (!(vector1[0] <= (double)vector2[0])) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!(vector1[0] <= (double)vector2[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!(vector1[0] <= (double)vector2[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!(vector1[i] <= (double)vector2[0])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!(vector1[i] <= (double)vector2[0])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!(vector1[i] <= (double)vector2[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (!(vector1[i] <= (double)vector2[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"double"), VectorExpressionDescriptor.ArgumentType.getType((String)"long")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

