/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class Decimal64ColMultiplyDecimal64Scalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final long value;

    public Decimal64ColMultiplyDecimal64Scalar(int colNum, long value, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.value = value;
    }

    public Decimal64ColMultiplyDecimal64Scalar() {
        this.value = 0L;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        Decimal64ColumnVector inputColVector = (Decimal64ColumnVector)batch.cols[this.inputColumnNum[0]];
        Decimal64ColumnVector outputColVector = (Decimal64ColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        long outputDecimal64AbsMax = HiveDecimalWritable.getDecimal64AbsMax(outputColVector.precision);
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                long result = vector[0] * this.value;
                if (Math.abs(result) > outputDecimal64AbsMax) {
                    outputIsNull[0] = true;
                    outputColVector.noNulls = false;
                } else {
                    outputVector[0] = result;
                }
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = result = vector[i] * this.value;
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        long result;
                        int i = sel[j];
                        outputVector[i] = result = vector[i] * this.value;
                        if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                        outputColVector.noNulls = false;
                        outputIsNull[i] = true;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    long result;
                    outputVector[i] = result = vector[i] * this.value;
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputColVector.noNulls = false;
                    outputIsNull[i] = true;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    long result;
                    outputIsNull[i] = false;
                    outputVector[i] = result = vector[i] * this.value;
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    long result;
                    outputIsNull[i] = false;
                    outputVector[i] = result = vector[i] * this.value;
                    if (Math.abs(result) <= outputDecimal64AbsMax) continue;
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.inputTypeInfos[0];
        HiveDecimalWritable writable = new HiveDecimalWritable();
        writable.deserialize64(this.value, decimalTypeInfo.scale());
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", decimal64Val " + this.value + ", decimalVal " + writable.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }

    @Override
    public boolean shouldConvertDecimal64ToDecimal() {
        return false;
    }
}

