/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Date;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class DateScalarSubtractIntervalYearMonthColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final Date value;
    private final transient HiveIntervalYearMonth scratchIntervalYearMonth2 = new HiveIntervalYearMonth();
    private final transient Date outputDate = new Date(0L);
    private final transient DateTimeMath dtm = new DateTimeMath();

    public DateScalarSubtractIntervalYearMonthColumn(long value, int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.value = new Date(DateWritableV2.daysToMillis((int)value));
    }

    public DateScalarSubtractIntervalYearMonthColumn() {
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector2 = inputColVector2.vector;
        long[] outputVector = outputColVector.vector;
        if (inputColVector2.isRepeating) {
            if (inputColVector2.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.scratchIntervalYearMonth2.set((int)vector2[0]);
                this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, this.outputDate);
                outputVector[0] = DateWritableV2.dateToDays(this.outputDate);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector2.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.scratchIntervalYearMonth2.set((int)vector2[i]);
                        this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, this.outputDate);
                        outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.scratchIntervalYearMonth2.set((int)vector2[i]);
                        this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, this.outputDate);
                        outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(this.value, this.scratchIntervalYearMonth2, this.outputDate);
                    outputVector[i] = DateWritableV2.dateToDays(this.outputDate);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value + ", " + this.getColumnParamString(1, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"date"), VectorExpressionDescriptor.ArgumentType.getType((String)"interval_year_month")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

