/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseScalar;

public class VectorUDFMapIndexLongScalar
extends VectorUDFMapIndexBaseScalar {
    private static final long serialVersionUID = 1L;
    private long key;

    public VectorUDFMapIndexLongScalar() {
    }

    public VectorUDFMapIndexLongScalar(int mapColumnNum, long key, int outputColumnNum) {
        super(mapColumnNum, outputColumnNum);
        this.key = key;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.key;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }

    @Override
    public int findScalarInMap(MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        long[] keys = ((LongColumnVector)mapColumnVector.keys).vector;
        for (int i = 0; i < count; ++i) {
            if (this.key != keys[offset + i]) continue;
            return offset + i;
        }
        return -1;
    }
}

