/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ListIndexColScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int index;

    public ListIndexColScalar() {
    }

    public ListIndexColScalar(int listColumn, int index, int outputColumnNum) {
        super(listColumn, outputColumnNum);
        this.index = index;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        ListColumnVector listV = (ListColumnVector)batch.cols[this.inputColumnNum[0]];
        ColumnVector childV = listV.child;
        int[] sel = batch.selected;
        boolean[] listIsNull = listV.isNull;
        boolean[] outputIsNull = outV.isNull;
        if (this.index < 0) {
            outV.isNull[0] = true;
            outV.noNulls = false;
            outV.isRepeating = true;
            return;
        }
        outV.isRepeating = false;
        if (listV.isRepeating) {
            if (listV.noNulls || !listIsNull[0]) {
                long repeatedLongListLength = listV.lengths[0];
                if ((long)this.index >= repeatedLongListLength) {
                    outV.isNull[0] = true;
                    outV.noNulls = false;
                } else {
                    outV.isNull[0] = false;
                    outV.setElement(0, (int)(listV.offsets[0] + (long)this.index), childV);
                }
            } else {
                outV.isNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (listV.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        long longListLength = listV.lengths[i];
                        if ((long)this.index >= longListLength) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.isNull[i] = false;
                        outV.setElement(i, (int)(listV.offsets[i] + (long)this.index), childV);
                    }
                } else {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        long longListLength = listV.lengths[i];
                        if ((long)this.index >= longListLength) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.setElement(i, (int)(listV.offsets[i] + (long)this.index), childV);
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outV.isNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i < n; ++i) {
                    long longListLength = listV.lengths[i];
                    if ((long)this.index >= longListLength) {
                        outV.isNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.setElement(i, (int)(listV.offsets[i] + (long)this.index), childV);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!listIsNull[i]) {
                    long longListLength = listV.lengths[i];
                    if ((long)this.index >= longListLength) {
                        outV.isNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.isNull[i] = false;
                    outV.setElement(i, (int)(listV.offsets[i] + (long)this.index), childV);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!listIsNull[i]) {
                    long longListLength = listV.lengths[i];
                    if ((long)this.index >= longListLength) {
                        outV.isNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.isNull[i] = false;
                    outV.setElement(i, (int)(listV.offsets[i] + (long)this.index), childV);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.index);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.LIST, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

