/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;

public class CuckooSetBytes {
    private byte[][] t1;
    private byte[][] t2;
    private byte[][] prev1 = null;
    private byte[][] prev2 = null;
    private int n;
    private static final double PADDING_FACTOR = 2.5;
    private int salt = 0;
    private Random gen = new Random(676983475L);
    private int rehashCount = 0;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final long BYTE_MASK = 255L;
    private int maxLen;
    private int minLen = Integer.MAX_VALUE;

    public CuckooSetBytes(int expectedSize) {
        this.n = (int)((double)expectedSize * 2.5 / 2.0);
        int[] primes = CuckooSetLong.primes;
        for (int i = 0; i != primes.length; ++i) {
            if (this.n > primes[i]) continue;
            this.n = primes[i];
            break;
        }
        this.t1 = new byte[this.n][];
        this.t2 = new byte[this.n][];
        this.updateHashSalt();
    }

    public boolean lookup(byte[] b, int start, int len) {
        if (len < this.minLen || len > this.maxLen) {
            return false;
        }
        return CuckooSetBytes.entryEqual(this.t1, this.h1(b, start, len), b, start, len) || CuckooSetBytes.entryEqual(this.t2, this.h2(b, start, len), b, start, len);
    }

    private static boolean entryEqual(byte[][] t, int hash, byte[] b, int start, int len) {
        return t[hash] != null && StringExpr.equal(t[hash], 0, t[hash].length, b, start, len);
    }

    public void insert(byte[] x) {
        if (this.lookup(x, 0, x.length)) {
            return;
        }
        this.minLen = Math.min(this.minLen, x.length);
        this.maxLen = Math.max(this.maxLen, x.length);
        for (int i = 0; i != this.n; ++i) {
            int hash1 = this.h1(x, 0, x.length);
            if (this.t1[hash1] == null) {
                this.t1[hash1] = x;
                return;
            }
            byte[] temp = this.t1[hash1];
            this.t1[hash1] = x;
            x = temp;
            int hash2 = this.h2(x, 0, x.length);
            if (this.t2[hash2] == null) {
                this.t2[hash2] = x;
                return;
            }
            temp = this.t2[hash2];
            this.t2[hash2] = x;
            x = temp;
        }
        this.rehash();
        this.insert(x);
    }

    public void load(byte[][] a) {
        for (byte[] x : a) {
            this.insert(x);
        }
    }

    private byte[] tryInsert(byte[] x) {
        for (int i = 0; i != this.n; ++i) {
            int hash1 = this.h1(x, 0, x.length);
            if (this.t1[hash1] == null) {
                this.t1[hash1] = x;
                return null;
            }
            byte[] temp = this.t1[hash1];
            this.t1[hash1] = x;
            x = temp;
            int hash2 = this.h2(x, 0, x.length);
            if (this.t2[hash2] == null) {
                this.t2[hash2] = x;
                return null;
            }
            temp = this.t2[hash2];
            this.t2[hash2] = x;
            x = temp;
            if (x == null) break;
        }
        return x;
    }

    private int h1(byte[] b, int start, int len) {
        return (this.hash(b, start, len, 0) & Integer.MAX_VALUE) % this.n;
    }

    private int h2(byte[] b, int start, int len) {
        return (this.hash(b, start, len, this.salt) & Integer.MAX_VALUE) % this.n;
    }

    private void updateHashSalt() {
        this.salt = this.gen.nextInt(Integer.MAX_VALUE);
    }

    private void rehash() {
        byte[] x;
        ++this.rehashCount;
        if (this.rehashCount > 20) {
            throw new RuntimeException("Too many rehashes");
        }
        this.updateHashSalt();
        if (this.prev1 == null) {
            this.prev1 = this.t1;
            this.prev2 = this.t2;
        }
        this.t1 = new byte[this.n][];
        this.t2 = new byte[this.n][];
        for (byte[] v : this.prev1) {
            if (v == null || (x = this.tryInsert(v)) == null) continue;
            this.rehash();
            return;
        }
        for (byte[] v : this.prev2) {
            if (v == null || (x = this.tryInsert(v)) == null) continue;
            this.rehash();
            return;
        }
        this.prev1 = null;
        this.prev2 = null;
    }

    private int hash(byte[] key, int start, int nbytes, int initval) {
        int length;
        long c;
        long b = c = 3735928559L + (long)length + (long)initval & 0xFFFFFFFFL;
        long a = c;
        int offset = start;
        for (length = nbytes; length > 12; length -= 12) {
            a = a + ((long)key[offset + 0] & 0xFFL) & 0xFFFFFFFFL;
            a = a + (((long)key[offset + 1] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            a = a + (((long)key[offset + 2] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            a = a + (((long)key[offset + 3] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            b = b + ((long)key[offset + 4] & 0xFFL) & 0xFFFFFFFFL;
            b = b + (((long)key[offset + 5] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            b = b + (((long)key[offset + 6] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            b = b + (((long)key[offset + 7] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            c = c + ((long)key[offset + 8] & 0xFFL) & 0xFFFFFFFFL;
            c = c + (((long)key[offset + 9] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            c = c + (((long)key[offset + 10] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            c = c + (((long)key[offset + 11] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            a = a - c & 0xFFFFFFFFL;
            a ^= CuckooSetBytes.rot(c, 4);
            c = c + b & 0xFFFFFFFFL;
            b = b - a & 0xFFFFFFFFL;
            b ^= CuckooSetBytes.rot(a, 6);
            a = a + c & 0xFFFFFFFFL;
            c = c - b & 0xFFFFFFFFL;
            c ^= CuckooSetBytes.rot(b, 8);
            b = b + a & 0xFFFFFFFFL;
            a = a - c & 0xFFFFFFFFL;
            a ^= CuckooSetBytes.rot(c, 16);
            c = c + b & 0xFFFFFFFFL;
            b = b - a & 0xFFFFFFFFL;
            b ^= CuckooSetBytes.rot(a, 19);
            a = a + c & 0xFFFFFFFFL;
            c = c - b & 0xFFFFFFFFL;
            c ^= CuckooSetBytes.rot(b, 4);
            b = b + a & 0xFFFFFFFFL;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c = c + (((long)key[offset + 11] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 11: {
                c = c + (((long)key[offset + 10] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 10: {
                c = c + (((long)key[offset + 9] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 9: {
                c = c + ((long)key[offset + 8] & 0xFFL) & 0xFFFFFFFFL;
            }
            case 8: {
                b = b + (((long)key[offset + 7] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 7: {
                b = b + (((long)key[offset + 6] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 6: {
                b = b + (((long)key[offset + 5] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 5: {
                b = b + ((long)key[offset + 4] & 0xFFL) & 0xFFFFFFFFL;
            }
            case 4: {
                a = a + (((long)key[offset + 3] & 0xFFL) << 24 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 3: {
                a = a + (((long)key[offset + 2] & 0xFFL) << 16 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 2: {
                a = a + (((long)key[offset + 1] & 0xFFL) << 8 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            case 1: {
                a = a + ((long)key[offset + 0] & 0xFFL) & 0xFFFFFFFFL;
                break;
            }
            case 0: {
                return (int)(c & 0xFFFFFFFFL);
            }
        }
        c ^= b;
        c = c - CuckooSetBytes.rot(b, 14) & 0xFFFFFFFFL;
        a ^= c;
        a = a - CuckooSetBytes.rot(c, 11) & 0xFFFFFFFFL;
        b ^= a;
        b = b - CuckooSetBytes.rot(a, 25) & 0xFFFFFFFFL;
        c ^= b;
        c = c - CuckooSetBytes.rot(b, 16) & 0xFFFFFFFFL;
        a ^= c;
        a = a - CuckooSetBytes.rot(c, 4) & 0xFFFFFFFFL;
        b ^= a;
        b = b - CuckooSetBytes.rot(a, 14) & 0xFFFFFFFFL;
        c ^= b;
        c = c - CuckooSetBytes.rot(b, 24) & 0xFFFFFFFFL;
        return (int)(c & 0xFFFFFFFFL);
    }

    private static long rot(long val, int pos) {
        return (long)Integer.rotateLeft((int)(val & 0xFFFFFFFFL), pos) & 0xFFFFFFFFL;
    }
}

