/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import hiveexec.com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hive.org.apache.datasketches.memory.Memory;
import org.codehaus.jackson.map.ObjectMapper;

public final class ShowUtils {
    public static final String FIELD_DELIM = "\t";
    public static final String LINE_DELIM = "\n";
    public static final int DEFAULT_STRINGBUILDER_SIZE = 2048;
    public static final int ALIGNMENT = 20;

    private ShowUtils() {
        throw new UnsupportedOperationException("ShowUtils should not be instantiated");
    }

    public static DataOutputStream getOutputStream(Path outputFile, DDLOperationContext context) throws HiveException {
        try {
            FileSystem fs = outputFile.getFileSystem((Configuration)context.getConf());
            return fs.create(outputFile);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static String propertiesToString(Map<String, String> properties, Set<String> exclude) {
        if (properties.isEmpty()) {
            return "";
        }
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(properties);
        ArrayList<String> realProps = new ArrayList<String>();
        for (Map.Entry e : sortedProperties.entrySet()) {
            if (e.getValue() == null || exclude.contains(e.getKey())) continue;
            realProps.add("  '" + (String)e.getKey() + "'='" + HiveStringUtils.escapeHiveCommand((String)e.getValue()) + "'");
        }
        return String.join((CharSequence)", \n", realProps);
    }

    public static void writeToFile(String data, String file, DDLOperationContext context) throws IOException {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        Path resFile = new Path(file);
        FileSystem fs = resFile.getFileSystem((Configuration)context.getConf());
        try (FSDataOutputStream out = fs.create(resFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            writer.write(data);
            writer.write(10);
            writer.flush();
        }
    }

    public static void appendNonNull(StringBuilder builder, Object value) {
        ShowUtils.appendNonNull(builder, value, false);
    }

    public static void appendNonNull(StringBuilder builder, Object value, boolean firstColumn) {
        if (!firstColumn) {
            builder.append('\t');
        } else if (builder.length() > 0) {
            builder.append('\n');
        }
        if (value != null) {
            builder.append(value);
        }
    }

    public static String[] extractColumnValues(FieldSchema column, boolean isColumnStatsAvailable, ColumnStatisticsObj columnStatisticsObj, boolean histogramEnabled) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(column.getName());
        values.add(column.getType());
        if (isColumnStatsAvailable) {
            if (columnStatisticsObj != null) {
                ColumnStatisticsData statsData = columnStatisticsObj.getStatsData();
                if (statsData.isSetBinaryStats()) {
                    BinaryColumnStatsData binaryStats = statsData.getBinaryStats();
                    values.addAll(Lists.newArrayList("", "", "" + binaryStats.getNumNulls(), "", "" + binaryStats.getAvgColLen(), "" + binaryStats.getMaxColLen(), "", "", ShowUtils.convertToString(binaryStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add("");
                    }
                } else if (statsData.isSetStringStats()) {
                    StringColumnStatsData stringStats = statsData.getStringStats();
                    values.addAll(Lists.newArrayList("", "", "" + stringStats.getNumNulls(), "" + stringStats.getNumDVs(), "" + stringStats.getAvgColLen(), "" + stringStats.getMaxColLen(), "", "", ShowUtils.convertToString(stringStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add("");
                    }
                } else if (statsData.isSetBooleanStats()) {
                    BooleanColumnStatsData booleanStats = statsData.getBooleanStats();
                    values.addAll(Lists.newArrayList("", "", "" + booleanStats.getNumNulls(), "", "", "", "" + booleanStats.getNumTrues(), "" + booleanStats.getNumFalses(), ShowUtils.convertToString(booleanStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add("");
                    }
                } else if (statsData.isSetDecimalStats()) {
                    DecimalColumnStatsData decimalStats = statsData.getDecimalStats();
                    values.addAll(Lists.newArrayList(ShowUtils.convertToString(decimalStats.getLowValue()), ShowUtils.convertToString(decimalStats.getHighValue()), "" + decimalStats.getNumNulls(), "" + decimalStats.getNumDVs(), "", "", "", "", ShowUtils.convertToString(decimalStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add(ShowUtils.convertHistogram(statsData.getDecimalStats().getHistogram(), (ColumnStatisticsData._Fields)statsData.getSetField()));
                    }
                } else if (statsData.isSetDoubleStats()) {
                    DoubleColumnStatsData doubleStats = statsData.getDoubleStats();
                    values.addAll(Lists.newArrayList("" + doubleStats.getLowValue(), "" + doubleStats.getHighValue(), "" + doubleStats.getNumNulls(), "" + doubleStats.getNumDVs(), "", "", "", "", ShowUtils.convertToString(doubleStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add(ShowUtils.convertHistogram(statsData.getDoubleStats().getHistogram(), (ColumnStatisticsData._Fields)statsData.getSetField()));
                    }
                } else if (statsData.isSetLongStats()) {
                    LongColumnStatsData longStats = statsData.getLongStats();
                    values.addAll(Lists.newArrayList("" + longStats.getLowValue(), "" + longStats.getHighValue(), "" + longStats.getNumNulls(), "" + longStats.getNumDVs(), "", "", "", "", ShowUtils.convertToString(longStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add(ShowUtils.convertHistogram(statsData.getLongStats().getHistogram(), (ColumnStatisticsData._Fields)statsData.getSetField()));
                    }
                } else if (statsData.isSetDateStats()) {
                    DateColumnStatsData dateStats = statsData.getDateStats();
                    values.addAll(Lists.newArrayList(ShowUtils.convertToString(dateStats.getLowValue()), ShowUtils.convertToString(dateStats.getHighValue()), "" + dateStats.getNumNulls(), "" + dateStats.getNumDVs(), "", "", "", "", ShowUtils.convertToString(dateStats.getBitVectors())));
                    if (histogramEnabled) {
                        values.add(ShowUtils.convertHistogram(statsData.getDateStats().getHistogram(), (ColumnStatisticsData._Fields)statsData.getSetField()));
                    }
                }
            } else {
                values.addAll(Lists.newArrayList("", "", "", "", "", "", "", "", ""));
                if (histogramEnabled) {
                    values.add("");
                }
            }
        }
        values.add(column.getComment() != null ? column.getComment() : "");
        return values.toArray(new String[0]);
    }

    public static String convertToString(Decimal val) {
        if (val == null) {
            return "";
        }
        HiveDecimal result = HiveDecimal.create(new BigInteger(val.getUnscaled()), (int)val.getScale());
        return result != null ? result.toString() : "";
    }

    public static String convertToString(Date val) {
        if (val == null) {
            return "";
        }
        DateWritableV2 writableValue = new DateWritableV2((int)val.getDaysSinceEpoch());
        return writableValue.toString();
    }

    private static String convertHistogram(byte[] buffer, ColumnStatisticsData._Fields field) {
        Function<Float, Object> converter;
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        KllFloatsSketch kll = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])buffer));
        float[] quantiles = kll.getQuantiles(new double[]{0.25, 0.5, 0.75});
        switch (1.$SwitchMap$org$apache$hadoop$hive$metastore$api$ColumnStatisticsData$_Fields[field.ordinal()]) {
            case 1: {
                converter = f -> org.apache.hadoop.hive.common.type.Date.valueOf(Timestamp.ofEpochSecond(f.longValue(), 0L, ShowUtils.getZoneIdFromConf()).toString());
                break;
            }
            case 2: {
                converter = HiveDecimal::create;
                break;
            }
            case 3: {
                converter = f -> f;
                break;
            }
            case 4: {
                converter = Float::longValue;
                break;
            }
            default: {
                return "";
            }
        }
        return kll.isEmpty() ? "" : "Q1: " + converter.apply(Float.valueOf(quantiles[0])) + ", Q2: " + converter.apply(Float.valueOf(quantiles[1])) + ", Q3: " + converter.apply(Float.valueOf(quantiles[2]));
    }

    private static ZoneId getZoneIdFromConf() {
        return SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
    }

    private static String convertToString(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        return new String(Arrays.copyOfRange(buffer, 0, 2));
    }

    public static void asJson(OutputStream out, Map<String, Object> data) throws HiveException {
        try {
            new ObjectMapper().writeValue(out, data);
        }
        catch (IOException e) {
            throw new HiveException("Unable to convert to json", e);
        }
    }

    public static void formatOutput(String[] fields, StringBuilder tableInfo, boolean isLastLinePadded, boolean isFormatted) {
        if (!isFormatted) {
            for (int i = 0; i < fields.length; ++i) {
                String value = HiveStringUtils.escapeJava(fields[i]);
                if (value != null) {
                    tableInfo.append((Object)value);
                }
                tableInfo.append(i == fields.length - 1 ? LINE_DELIM : FIELD_DELIM);
            }
        } else {
            int[] paddings = new int[fields.length - 1];
            if (fields.length > 1) {
                for (int i = 0; i < fields.length - 1; ++i) {
                    if (fields[i] == null) {
                        tableInfo.append(FIELD_DELIM);
                        continue;
                    }
                    tableInfo.append(String.format("%-20s", fields[i])).append(FIELD_DELIM);
                    paddings[i] = 20 > fields[i].length() ? 20 : fields[i].length();
                }
            }
            if (fields.length > 0) {
                String value = fields[fields.length - 1];
                String unescapedValue = isLastLinePadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
                ShowUtils.indentMultilineValue(unescapedValue, tableInfo, paddings, false);
            } else {
                tableInfo.append(LINE_DELIM);
            }
        }
    }

    public static void formatOutput(String[] fields, StringBuilder tableInfo) {
        ShowUtils.formatOutput(fields, tableInfo, false, true);
    }

    public static void formatOutput(String name, String value, StringBuilder tableInfo) {
        tableInfo.append(String.format("%-20s", name)).append(FIELD_DELIM);
        int colNameLength = Math.max(20, name.length());
        ShowUtils.indentMultilineValue(value, tableInfo, new int[]{0, colNameLength}, true);
    }

    public static void formatOutput(String name, String value, StringBuilder tableInfo, boolean isOutputPadded) {
        String unescapedValue = isOutputPadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
        ShowUtils.formatOutput(name, unescapedValue, tableInfo);
    }

    private static void indentMultilineValue(String value, StringBuilder tableInfo, int[] columnWidths, boolean printNull) {
        if (value == null) {
            if (printNull) {
                tableInfo.append(String.format("%-20s", value));
            }
            tableInfo.append(LINE_DELIM);
        } else {
            String[] valueSegments = value.split("\n|\r|\r\n");
            tableInfo.append(String.format("%-20s", valueSegments[0])).append(LINE_DELIM);
            for (int i = 1; i < valueSegments.length; ++i) {
                ShowUtils.printPadding(tableInfo, columnWidths);
                tableInfo.append(String.format("%-20s", valueSegments[i])).append(LINE_DELIM);
            }
        }
    }

    private static void printPadding(StringBuilder tableInfo, int[] columnWidths) {
        for (int columnWidth : columnWidths) {
            if (columnWidth == 0) {
                tableInfo.append(FIELD_DELIM);
                continue;
            }
            tableInfo.append(String.format("%" + columnWidth + "s" + FIELD_DELIM, ""));
        }
    }
}

