/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import org.apache.hive.common.util.Murmur3;

public class HashCodeUtil {
    public static int calculateIntHashCode(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key;
    }

    public static int calculateTwoLongHashCode(long l0, long l1) {
        return Murmur3.hash32(l0, l1);
    }

    public static int calculateLongHashCode(long key) {
        return Murmur3.hash32(key);
    }

    public static void calculateLongArrayHashCodes(long[] longs, int[] hashCodes, int count) {
        for (int v = 0; v < count; ++v) {
            hashCodes[v] = HashCodeUtil.calculateLongHashCode(longs[v]);
        }
    }

    public static int calculateBytesHashCode(byte[] keyBytes, int keyStart, int keyLength) {
        return HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
    }

    public static void calculateBytesArrayHashCodes(byte[][] bytesArrays, int[] starts, int[] lengths, int[] valueSelected, int[] hashCodes, int count) {
        for (int i = 0; i < count; ++i) {
            int batchIndex = valueSelected[i];
            hashCodes[i] = HashCodeUtil.murmurHash(bytesArrays[batchIndex], starts[batchIndex], lengths[batchIndex]);
        }
    }

    public static int murmurHash(byte[] data, int offset, int length) {
        int m = 1540483477;
        int r = 24;
        int h = length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = offset + (i << 2);
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            length += offset;
            if (left >= 3) {
                h ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[length - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }
}

