/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveIntervalDayTimeObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveIntervalYearMonthObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types"})
public class LazyBinarySerDe2
extends LazyBinarySerDe {
    LBSerializer rowSerializer;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        super.initialize(conf, tbl);
        ObjectInspector oi = this.getObjectInspector();
        this.rowSerializer = this.createLBSerializer(oi);
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        this.serializeByteStream.reset();
        this.rowSerializer.serializeValue(this.serializeByteStream, obj, objInspector, true, this.nullMapKey);
        this.serializeBytesWritable.set(this.serializeByteStream.getData(), 0, this.serializeByteStream.getLength());
        this.serializedSize = this.serializeByteStream.getLength();
        this.lastOperationSerialize = true;
        this.lastOperationDeserialize = false;
        return this.serializeBytesWritable;
    }

    LBSerializer createPrimitiveLBSerializer(PrimitiveObjectInspector poi) {
        switch (poi.getPrimitiveCategory()) {
            case VOID: {
                return new LBVoidSerializer();
            }
            case BOOLEAN: {
                return new LBBooleanSerializer();
            }
            case BYTE: {
                return new LBByteSerializer();
            }
            case SHORT: {
                return new LBShortSerializer();
            }
            case INT: {
                return new LBIntSerializer();
            }
            case LONG: {
                return new LBLongSerializer();
            }
            case FLOAT: {
                return new LBFloatSerializer();
            }
            case DOUBLE: {
                return new LBDoubleSerializer();
            }
            case STRING: {
                return new LBStringSerializer();
            }
            case CHAR: {
                return new LBHiveCharSerializer();
            }
            case VARCHAR: {
                return new LBHiveVarcharSerializer();
            }
            case BINARY: {
                return new LBBinarySerializer();
            }
            case DATE: {
                return new LBDateSerializer();
            }
            case TIMESTAMP: {
                return new LBTimestampSerializer();
            }
            case INTERVAL_YEAR_MONTH: {
                return new LBHiveIntervalYearMonthSerializer();
            }
            case INTERVAL_DAY_TIME: {
                return new LBHiveIntervalDayTimeSerializer();
            }
            case DECIMAL: {
                return new LBHiveDecimalSerializer();
            }
            case TIMESTAMPLOCALTZ: {
                return new LBTimestampLocalTZSerializer();
            }
        }
        throw new IllegalArgumentException("Unsupported primitive category " + (Object)((Object)poi.getPrimitiveCategory()));
    }

    LBSerializer createLBSerializer(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                return this.createPrimitiveLBSerializer(poi);
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                ObjectInspector eoi = loi.getListElementObjectInspector();
                return new LBListSerializer(this.createLBSerializer(eoi));
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                return new LBMapSerializer(this.createLBSerializer(koi), this.createLBSerializer(voi));
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                LBSerializer[] fieldSerializers = new LBSerializer[fields.size()];
                for (int idx = 0; idx < fieldSerializers.length; ++idx) {
                    fieldSerializers[idx] = this.createLBSerializer(fields.get(idx).getFieldObjectInspector());
                }
                return new LBStructSerializer(fieldSerializers);
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                List<ObjectInspector> unionFields = uoi.getObjectInspectors();
                LBSerializer[] unionFieldSerializers = new LBSerializer[unionFields.size()];
                for (int idx = 0; idx < unionFieldSerializers.length; ++idx) {
                    unionFieldSerializers[idx] = this.createLBSerializer(unionFields.get(idx));
                }
                return new LBUnionSerializer(unionFieldSerializers);
            }
        }
        throw new IllegalArgumentException("Unsupported category " + (Object)((Object)oi.getCategory()));
    }

    static class LBUnionSerializer
    extends LBSerializer {
        LBSerializer[] unionFieldSerializers;

        public LBUnionSerializer(LBSerializer[] unionFieldSerializers) {
            this.unionFieldSerializers = unionFieldSerializers;
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            int byteSizeStart = 0;
            int typeStart = 0;
            if (!skipLengthPrefix) {
                byteSizeStart = byteStream.getLength();
                byteStream.reserve(4);
                typeStart = byteStream.getLength();
            }
            UnionObjectInspector uoi = (UnionObjectInspector)objInspector;
            byte tag = uoi.getTag(obj);
            byteStream.write(tag);
            this.unionFieldSerializers[tag].serializeValue(byteStream, uoi.getField(obj), uoi.getObjectInspectors().get(tag), false, warnedOnceNullMapKey);
            if (!skipLengthPrefix) {
                int typeEnd = byteStream.getLength();
                int typeSize = typeEnd - typeStart;
                LazyBinarySerDe.writeSizeAtOffset(byteStream, byteSizeStart, typeSize);
            }
        }
    }

    static class LBStructSerializer
    extends LBSerializer {
        LBSerializer[] serializers;
        Object[] fieldData;

        public LBStructSerializer(LBSerializer[] serializers) {
            this.serializers = serializers;
            this.fieldData = new Object[serializers.length];
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            int i;
            int lasti = 0;
            int nullByte = 0;
            int size = this.serializers.length;
            int byteSizeStart = 0;
            int typeStart = 0;
            if (!skipLengthPrefix) {
                byteSizeStart = byteStream.getLength();
                byteStream.reserve(4);
                typeStart = byteStream.getLength();
            }
            StructObjectInspector soi = (StructObjectInspector)objInspector;
            List<? extends StructField> fields = soi.getAllStructFieldRefs();
            for (i = 0; i < size; ++i) {
                StructField structField = fields.get(i);
                this.fieldData[i] = soi.getStructFieldData(obj, structField);
            }
            for (i = 0; i < size; ++i) {
                if (null != this.fieldData[i]) {
                    nullByte = (byte)(nullByte | 1 << i % 8);
                }
                if (7 != i % 8 && i != size - 1) continue;
                byteStream.write(nullByte);
                for (int j = lasti; j <= i; ++j) {
                    this.serializers[j].serializeValue(byteStream, this.fieldData[j], fields.get(j).getFieldObjectInspector(), false, warnedOnceNullMapKey);
                }
                lasti = i + 1;
                nullByte = 0;
            }
            if (!skipLengthPrefix) {
                int typeEnd = byteStream.getLength();
                int typeSize = typeEnd - typeStart;
                LazyBinarySerDe.writeSizeAtOffset(byteStream, byteSizeStart, typeSize);
            }
        }
    }

    static class LBMapSerializer
    extends LBSerializer {
        LBSerializer keySerializer;
        LBSerializer valSerializer;

        public LBMapSerializer(LBSerializer keySerializer, LBSerializer valSerializer) {
            this.keySerializer = keySerializer;
            this.valSerializer = valSerializer;
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            MapObjectInspector moi = (MapObjectInspector)objInspector;
            ObjectInspector koi = moi.getMapKeyObjectInspector();
            ObjectInspector voi = moi.getMapValueObjectInspector();
            Map<?, ?> map = moi.getMap(obj);
            int byteSizeStart = 0;
            int mapStart = 0;
            if (!skipLengthPrefix) {
                byteSizeStart = byteStream.getLength();
                byteStream.reserve(4);
                mapStart = byteStream.getLength();
            }
            int size = map.size();
            LazyBinaryUtils.writeVInt(byteStream, size);
            int b = 0;
            int nullByte = 0;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (null != entry.getKey()) {
                    nullByte = (byte)(nullByte | 1 << b % 8);
                } else if (warnedOnceNullMapKey != null) {
                    if (!warnedOnceNullMapKey.value) {
                        LazyBinarySerDe.LOG.warn("Null map key encountered! Ignoring similar problems.");
                    }
                    warnedOnceNullMapKey.value = true;
                }
                ++b;
                if (null != entry.getValue()) {
                    nullByte = (byte)(nullByte | 1 << b % 8);
                }
                if (0 != ++b % 8 && b != size * 2) continue;
                byteStream.write(nullByte);
                nullByte = 0;
            }
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.keySerializer.serializeValue(byteStream, entry.getKey(), koi, false, warnedOnceNullMapKey);
                this.valSerializer.serializeValue(byteStream, entry.getValue(), voi, false, warnedOnceNullMapKey);
            }
            if (!skipLengthPrefix) {
                int mapEnd = byteStream.getLength();
                int mapSize = mapEnd - mapStart;
                LazyBinarySerDe.writeSizeAtOffset(byteStream, byteSizeStart, mapSize);
            }
        }
    }

    static class LBListSerializer
    extends LBSerializer {
        LBSerializer elementSerializer;

        public LBListSerializer(LBSerializer elementSerializer) {
            this.elementSerializer = elementSerializer;
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            int eid;
            ListObjectInspector loi = (ListObjectInspector)objInspector;
            ObjectInspector eoi = loi.getListElementObjectInspector();
            int byteSizeStart = 0;
            int listStart = 0;
            if (!skipLengthPrefix) {
                byteSizeStart = byteStream.getLength();
                byteStream.reserve(4);
                listStart = byteStream.getLength();
            }
            int size = loi.getListLength(obj);
            LazyBinaryUtils.writeVInt(byteStream, size);
            int nullByte = 0;
            for (eid = 0; eid < size; ++eid) {
                if (null != loi.getListElement(obj, eid)) {
                    nullByte = (byte)(nullByte | 1 << eid % 8);
                }
                if (7 != eid % 8 && eid != size - 1) continue;
                byteStream.write(nullByte);
                nullByte = 0;
            }
            for (eid = 0; eid < size; ++eid) {
                this.elementSerializer.serializeValue(byteStream, loi.getListElement(obj, eid), eoi, false, warnedOnceNullMapKey);
            }
            if (!skipLengthPrefix) {
                int listEnd = byteStream.getLength();
                int listSize = listEnd - listStart;
                LazyBinarySerDe.writeSizeAtOffset(byteStream, byteSizeStart, listSize);
            }
        }
    }

    static class LBTimestampLocalTZSerializer
    extends LBSerializer {
        LBTimestampLocalTZSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            TimestampLocalTZWritable t = ((TimestampLocalTZObjectInspector)objInspector).getPrimitiveWritableObject(obj);
            t.writeToByteStream(byteStream);
        }
    }

    static class LBHiveDecimalSerializer
    extends LBSerializer {
        LBHiveDecimalSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            HiveDecimalObjectInspector bdoi = (HiveDecimalObjectInspector)objInspector;
            HiveDecimalWritable t = bdoi.getPrimitiveWritableObject(obj);
            if (t == null) {
                return;
            }
            LazyBinarySerDe.writeToByteStream(byteStream, t);
        }
    }

    static class LBHiveIntervalDayTimeSerializer
    extends LBSerializer {
        LBHiveIntervalDayTimeSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            HiveIntervalDayTimeWritable intervalDayTime = ((HiveIntervalDayTimeObjectInspector)objInspector).getPrimitiveWritableObject(obj);
            intervalDayTime.writeToByteStream(byteStream);
        }
    }

    static class LBHiveIntervalYearMonthSerializer
    extends LBSerializer {
        LBHiveIntervalYearMonthSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            HiveIntervalYearMonthWritable intervalYearMonth = ((HiveIntervalYearMonthObjectInspector)objInspector).getPrimitiveWritableObject(obj);
            intervalYearMonth.writeToByteStream(byteStream);
        }
    }

    static class LBTimestampSerializer
    extends LBSerializer {
        LBTimestampSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            TimestampObjectInspector toi = (TimestampObjectInspector)objInspector;
            TimestampWritableV2 t = toi.getPrimitiveWritableObject(obj);
            t.writeToByteStream(byteStream);
        }
    }

    static class LBDateSerializer
    extends LBSerializer {
        LBDateSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            DateWritableV2 d = ((DateObjectInspector)objInspector).getPrimitiveWritableObject(obj);
            LazyBinarySerDe.writeDateToByteStream(byteStream, d);
        }
    }

    static class LBBinarySerializer
    extends LBSerializer {
        LBBinarySerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            BinaryObjectInspector baoi = (BinaryObjectInspector)objInspector;
            BytesWritable bw = baoi.getPrimitiveWritableObject(obj);
            int length = bw.getLength();
            if (!skipLengthPrefix) {
                LazyBinaryUtils.writeVInt(byteStream, length);
            } else if (length == 0) {
                throw new RuntimeException("LazyBinaryColumnarSerde cannot serialize a non-null zero length binary field. Consider using either LazyBinarySerde or ColumnarSerde.");
            }
            byteStream.write(bw.getBytes(), 0, length);
        }
    }

    static class LBHiveVarcharSerializer
    extends LBSerializer {
        LBHiveVarcharSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            HiveVarcharObjectInspector hcoi = (HiveVarcharObjectInspector)objInspector;
            Text t = hcoi.getPrimitiveWritableObject(obj).getTextValue();
            LazyBinarySerDe.serializeText(byteStream, t, skipLengthPrefix);
        }
    }

    static class LBHiveCharSerializer
    extends LBSerializer {
        LBHiveCharSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            HiveCharObjectInspector hcoi = (HiveCharObjectInspector)objInspector;
            Text t = hcoi.getPrimitiveWritableObject(obj).getTextValue();
            LazyBinarySerDe.serializeText(byteStream, t, skipLengthPrefix);
        }
    }

    static class LBStringSerializer
    extends LBSerializer {
        LBStringSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            StringObjectInspector soi = (StringObjectInspector)objInspector;
            Text t = soi.getPrimitiveWritableObject(obj);
            LazyBinarySerDe.serializeText(byteStream, t, skipLengthPrefix);
        }
    }

    static class LBDoubleSerializer
    extends LBSerializer {
        LBDoubleSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            DoubleObjectInspector doi = (DoubleObjectInspector)objInspector;
            LazyBinaryUtils.writeDouble(byteStream, doi.get(obj));
        }
    }

    static class LBFloatSerializer
    extends LBSerializer {
        LBFloatSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            FloatObjectInspector foi = (FloatObjectInspector)objInspector;
            int v = Float.floatToIntBits(foi.get(obj));
            byteStream.write((byte)(v >> 24));
            byteStream.write((byte)(v >> 16));
            byteStream.write((byte)(v >> 8));
            byteStream.write((byte)v);
        }
    }

    static class LBLongSerializer
    extends LBSerializer {
        LBLongSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            LongObjectInspector loi = (LongObjectInspector)objInspector;
            long v = loi.get(obj);
            LazyBinaryUtils.writeVLong(byteStream, v);
        }
    }

    static class LBIntSerializer
    extends LBSerializer {
        LBIntSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            IntObjectInspector ioi = (IntObjectInspector)objInspector;
            int v = ioi.get(obj);
            LazyBinaryUtils.writeVInt(byteStream, v);
        }
    }

    static class LBShortSerializer
    extends LBSerializer {
        LBShortSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            ShortObjectInspector spoi = (ShortObjectInspector)objInspector;
            short v = spoi.get(obj);
            byteStream.write((byte)(v >> 8));
            byteStream.write((byte)v);
        }
    }

    static class LBByteSerializer
    extends LBSerializer {
        LBByteSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            ByteObjectInspector boi = (ByteObjectInspector)objInspector;
            byte v = boi.get(obj);
            byteStream.write(v);
        }
    }

    static class LBBooleanSerializer
    extends LBSerializer {
        LBBooleanSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            boolean v = ((BooleanObjectInspector)objInspector).get(obj);
            byteStream.write((byte)(v ? 1 : 0));
        }
    }

    static class LBVoidSerializer
    extends LBSerializer {
        LBVoidSerializer() {
        }

        @Override
        void serialize(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
        }
    }

    static abstract class LBSerializer {
        LBSerializer() {
        }

        public void serializeValue(ByteStream.RandomAccessOutput byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, LazyBinarySerDe.BooleanRef warnedOnceNullMapKey) {
            if (obj != null) {
                this.serialize(byteStream, obj, objInspector, skipLengthPrefix, warnedOnceNullMapKey);
            }
        }

        abstract void serialize(ByteStream.RandomAccessOutput var1, Object var2, ObjectInspector var3, boolean var4, LazyBinarySerDe.BooleanRef var5);
    }
}

