/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.TimestampParser;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "timestamp.formats"})
public class JsonSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerDe.class);
    private List<String> columnNames;
    private StructTypeInfo schema;
    private JsonFactory jsonFactory = null;
    private StandardStructObjectInspector cachedObjectInspector;
    private TimestampParser tsParser;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        StructTypeInfo rowTypeInfo;
        LOG.debug("Initializing JsonSerDe: {}", tbl.entrySet());
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        this.columnNames = columnNameProperty.isEmpty() ? Collections.emptyList() : Arrays.asList(columnNameProperty.split(columnNameDelimiter));
        List<TypeInfo> columnTypes = columnTypeProperty.isEmpty() ? Collections.emptyList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        LOG.debug("columns: {}, {}", (Object)columnNameProperty, this.columnNames);
        LOG.debug("types: {}, {} ", (Object)columnTypeProperty, columnTypes);
        assert (this.columnNames.size() == columnTypes.size());
        this.schema = rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, columnTypes);
        LOG.debug("schema : {}", (Object)this.schema);
        this.cachedObjectInspector = (StandardStructObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(rowTypeInfo);
        this.jsonFactory = new JsonFactory();
        this.tsParser = new TimestampParser(HiveStringUtils.splitAndUnEscape(tbl.getProperty("timestamp.formats")));
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        Text t = (Text)blob;
        ArrayList<Object> r = new ArrayList<Object>(Collections.nCopies(this.columnNames.size(), null));
        try {
            JsonToken token;
            JsonParser p = this.jsonFactory.createJsonParser((InputStream)new ByteArrayInputStream(t.getBytes()));
            if (p.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Start token not found where expected");
            }
            while ((token = p.nextToken()) != JsonToken.END_OBJECT && token != null) {
                this.populateRecord(r, token, p, this.schema);
            }
        }
        catch (JsonParseException e) {
            LOG.warn("Error [{}] parsing json text [{}].", (Object)e, (Object)t);
            throw new SerDeException(e);
        }
        catch (IOException e) {
            LOG.warn("Error [{}] parsing json text [{}].", (Object)e, (Object)t);
            throw new SerDeException(e);
        }
        return r;
    }

    private void populateRecord(List<Object> r, JsonToken token, JsonParser p, StructTypeInfo s) throws IOException {
        if (token != JsonToken.FIELD_NAME) {
            throw new IOException("Field name expected");
        }
        String fieldName = p.getText().toLowerCase();
        int fpos = s.getAllStructFieldNames().indexOf(fieldName);
        if (fpos == -1) {
            fpos = this.getPositionFromHiveInternalColumnName(fieldName);
            LOG.debug("NPE finding position for field [{}] in schema [{}], attempting to check if it is an internal column name like _col0", (Object)fieldName, (Object)s);
            if (fpos == -1) {
                this.skipValue(p);
                return;
            }
            if (!fieldName.equalsIgnoreCase(this.getHiveInternalColumnName(fpos))) {
                LOG.error("Hive internal column name {} and position encoding {} for the column name are at odds", (Object)fieldName, (Object)fpos);
                throw new IOException("Hive internal column name (" + fieldName + ") and position encoding (" + fpos + ") for the column name are at odds");
            }
        }
        Object currField = this.extractCurrentField(p, s.getStructFieldTypeInfo(fieldName), false);
        r.set(fpos, currField);
    }

    public String getHiveInternalColumnName(int fpos) {
        return HiveConf.getColumnInternalName(fpos);
    }

    public int getPositionFromHiveInternalColumnName(String internalName) {
        Pattern internalPattern = Pattern.compile("_col([0-9]+)");
        Matcher m = internalPattern.matcher(internalName);
        if (!m.matches()) {
            return -1;
        }
        return Integer.parseInt(m.group(1));
    }

    private void skipValue(JsonParser p) throws JsonParseException, IOException {
        JsonToken valueToken = p.nextToken();
        if (valueToken == JsonToken.START_ARRAY || valueToken == JsonToken.START_OBJECT) {
            p.skipChildren();
        }
    }

    private Object extractCurrentField(JsonParser p, TypeInfo fieldTypeInfo, boolean isTokenCurrent) throws IOException {
        ArrayList<Object> val = null;
        JsonToken valueToken = isTokenCurrent ? p.getCurrentToken() : p.nextToken();
        switch (fieldTypeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN;
                if (fieldTypeInfo instanceof PrimitiveTypeInfo) {
                    primitiveCategory = ((PrimitiveTypeInfo)fieldTypeInfo).getPrimitiveCategory();
                }
                switch (primitiveCategory) {
                    case INT: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Integer.valueOf(p.getIntValue());
                        break;
                    }
                    case BYTE: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Byte.valueOf(p.getByteValue());
                        break;
                    }
                    case SHORT: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Short.valueOf(p.getShortValue());
                        break;
                    }
                    case LONG: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Long.valueOf(p.getLongValue());
                        break;
                    }
                    case BOOLEAN: {
                        String bval;
                        String string = bval = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                        if (bval != null) {
                            val = Boolean.valueOf(bval);
                            break;
                        }
                        val = null;
                        break;
                    }
                    case FLOAT: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Float.valueOf(p.getFloatValue());
                        break;
                    }
                    case DOUBLE: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Double.valueOf(p.getDoubleValue());
                        break;
                    }
                    case STRING: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                        break;
                    }
                    case BINARY: {
                        String b;
                        String string = b = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                        if (b != null) {
                            try {
                                String t = Text.decode((byte[])b.getBytes(), (int)0, (int)b.getBytes().length);
                                return t.getBytes();
                            }
                            catch (CharacterCodingException e) {
                                LOG.warn("Error generating json binary type from object.", (Throwable)e);
                                return null;
                            }
                        }
                        val = null;
                        break;
                    }
                    case DATE: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : Date.valueOf(p.getText());
                        break;
                    }
                    case TIMESTAMP: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : this.tsParser.parseTimestamp(p.getText());
                        break;
                    }
                    case DECIMAL: {
                        val = valueToken == JsonToken.VALUE_NULL ? null : HiveDecimal.create(p.getText());
                        break;
                    }
                    case VARCHAR: {
                        int vLen = ((BaseCharTypeInfo)fieldTypeInfo).getLength();
                        val = valueToken == JsonToken.VALUE_NULL ? null : new HiveVarchar(p.getText(), vLen);
                        break;
                    }
                    case CHAR: {
                        int cLen = ((BaseCharTypeInfo)fieldTypeInfo).getLength();
                        val = valueToken == JsonToken.VALUE_NULL ? null : new HiveChar(p.getText(), cLen);
                    }
                }
                break;
            }
            case LIST: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_ARRAY) {
                    throw new IOException("Start of Array expected");
                }
                ArrayList<Object> arr = new ArrayList<Object>();
                while ((valueToken = p.nextToken()) != JsonToken.END_ARRAY) {
                    arr.add(this.extractCurrentField(p, ((ListTypeInfo)fieldTypeInfo).getListElementTypeInfo(), true));
                }
                val = arr;
                break;
            }
            case MAP: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_OBJECT) {
                    throw new IOException("Start of Object expected");
                }
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                while ((valueToken = p.nextToken()) != JsonToken.END_OBJECT) {
                    Object k = this.getObjectOfCorrespondingPrimitiveType(p.getCurrentName(), (PrimitiveTypeInfo)((MapTypeInfo)fieldTypeInfo).getMapKeyTypeInfo());
                    Object v = this.extractCurrentField(p, ((MapTypeInfo)fieldTypeInfo).getMapValueTypeInfo(), false);
                    map.put(k, v);
                }
                val = map;
                break;
            }
            case STRUCT: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_OBJECT) {
                    throw new IOException("Start of Object expected");
                }
                ArrayList<TypeInfo> subSchema = ((StructTypeInfo)fieldTypeInfo).getAllStructFieldTypeInfos();
                int sz = subSchema.size();
                ArrayList<Object> struct = new ArrayList<Object>(Collections.nCopies(sz, null));
                while ((valueToken = p.nextToken()) != JsonToken.END_OBJECT) {
                    this.populateRecord(struct, valueToken, p, (StructTypeInfo)fieldTypeInfo);
                }
                val = struct;
                break;
            }
            default: {
                LOG.error("Unknown type found: " + fieldTypeInfo);
                return null;
            }
        }
        return val;
    }

    private Object getObjectOfCorrespondingPrimitiveType(String s, PrimitiveTypeInfo mapKeyType) throws IOException {
        switch (mapKeyType.getPrimitiveCategory()) {
            case INT: {
                return Integer.valueOf(s);
            }
            case BYTE: {
                return Byte.valueOf(s);
            }
            case SHORT: {
                return Short.valueOf(s);
            }
            case LONG: {
                return Long.valueOf(s);
            }
            case BOOLEAN: {
                return s.equalsIgnoreCase("true");
            }
            case FLOAT: {
                return Float.valueOf(s);
            }
            case DOUBLE: {
                return Double.valueOf(s);
            }
            case STRING: {
                return s;
            }
            case BINARY: {
                try {
                    String t = Text.decode((byte[])s.getBytes(), (int)0, (int)s.getBytes().length);
                    return t.getBytes();
                }
                catch (CharacterCodingException e) {
                    LOG.warn("Error generating json binary type from object.", (Throwable)e);
                    return null;
                }
            }
            case DATE: {
                return Date.valueOf(s);
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(s);
            }
            case DECIMAL: {
                return HiveDecimal.create(s);
            }
            case VARCHAR: {
                return new HiveVarchar(s, ((BaseCharTypeInfo)mapKeyType).getLength());
            }
            case CHAR: {
                return new HiveChar(s, ((BaseCharTypeInfo)mapKeyType).getLength());
            }
        }
        throw new IOException("Could not convert from string to map type " + mapKeyType.getTypeName());
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        StringBuilder sb = new StringBuilder();
        try {
            StructObjectInspector soi = (StructObjectInspector)objInspector;
            List<? extends StructField> structFields = soi.getAllStructFieldRefs();
            assert (this.columnNames.size() == structFields.size());
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append("{");
                for (int i = 0; i < structFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerDe.appendWithQuotes(sb, this.columnNames.get(i));
                    sb.append(':');
                    JsonSerDe.buildJSONString(sb, soi.getStructFieldData(obj, structFields.get(i)), structFields.get(i).getFieldObjectInspector());
                }
                sb.append("}");
            }
        }
        catch (IOException e) {
            LOG.warn("Error generating json text from object.", (Throwable)e);
            throw new SerDeException(e);
        }
        return new Text(sb.toString());
    }

    private static StringBuilder appendWithQuotes(StringBuilder sb, String value) {
        return sb == null ? null : sb.append('\"').append(value).append('\"');
    }

    private static void buildJSONString(StringBuilder sb, Object o, ObjectInspector oi) throws IOException {
        block0 : switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                if (o == null) {
                    sb.append("null");
                    break;
                }
                switch (poi.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        boolean b = ((BooleanObjectInspector)poi).get(o);
                        sb.append(b ? "true" : "false");
                        break block0;
                    }
                    case BYTE: {
                        sb.append(((ByteObjectInspector)poi).get(o));
                        break block0;
                    }
                    case SHORT: {
                        sb.append(((ShortObjectInspector)poi).get(o));
                        break block0;
                    }
                    case INT: {
                        sb.append(((IntObjectInspector)poi).get(o));
                        break block0;
                    }
                    case LONG: {
                        sb.append(((LongObjectInspector)poi).get(o));
                        break block0;
                    }
                    case FLOAT: {
                        sb.append(((FloatObjectInspector)poi).get(o));
                        break block0;
                    }
                    case DOUBLE: {
                        sb.append(((DoubleObjectInspector)poi).get(o));
                        break block0;
                    }
                    case STRING: {
                        String s = SerDeUtils.escapeString(((StringObjectInspector)poi).getPrimitiveJavaObject(o));
                        JsonSerDe.appendWithQuotes(sb, s);
                        break block0;
                    }
                    case BINARY: {
                        byte[] b = ((BinaryObjectInspector)oi).getPrimitiveJavaObject(o);
                        Text txt = new Text();
                        txt.set(b, 0, b.length);
                        JsonSerDe.appendWithQuotes(sb, SerDeUtils.escapeString(txt.toString()));
                        break block0;
                    }
                    case DATE: {
                        Date d = ((DateObjectInspector)poi).getPrimitiveJavaObject(o);
                        JsonSerDe.appendWithQuotes(sb, d.toString());
                        break block0;
                    }
                    case TIMESTAMP: {
                        Timestamp t = ((TimestampObjectInspector)poi).getPrimitiveJavaObject(o);
                        JsonSerDe.appendWithQuotes(sb, t.toString());
                        break block0;
                    }
                    case DECIMAL: {
                        sb.append(((HiveDecimalObjectInspector)poi).getPrimitiveJavaObject(o));
                        break block0;
                    }
                    case VARCHAR: {
                        String s = SerDeUtils.escapeString(((HiveVarcharObjectInspector)poi).getPrimitiveJavaObject(o).toString());
                        JsonSerDe.appendWithQuotes(sb, s);
                        break block0;
                    }
                    case CHAR: {
                        String s = SerDeUtils.escapeString(((HiveCharObjectInspector)poi).getPrimitiveJavaObject(o).toString());
                        JsonSerDe.appendWithQuotes(sb, s);
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown primitive type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                ObjectInspector listElementObjectInspector = loi.getListElementObjectInspector();
                List<?> olist = loi.getList(o);
                if (olist == null) {
                    sb.append("null");
                    break;
                }
                sb.append("[");
                for (int i = 0; i < olist.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerDe.buildJSONString(sb, olist.get(i), listElementObjectInspector);
                }
                sb.append("]");
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector mapKeyObjectInspector = moi.getMapKeyObjectInspector();
                ObjectInspector mapValueObjectInspector = moi.getMapValueObjectInspector();
                Map<?, ?> omap = moi.getMap(o);
                if (omap == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                boolean first = true;
                for (Map.Entry<?, ?> entry : omap.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    Map.Entry<?, ?> e = entry;
                    StringBuilder keyBuilder = new StringBuilder();
                    JsonSerDe.buildJSONString(keyBuilder, e.getKey(), mapKeyObjectInspector);
                    String keyString = keyBuilder.toString().trim();
                    if (!keyString.isEmpty() && keyString.charAt(0) != '\"') {
                        JsonSerDe.appendWithQuotes(sb, keyString);
                    } else {
                        sb.append(keyString);
                    }
                    sb.append(':');
                    JsonSerDe.buildJSONString(sb, e.getValue(), mapValueObjectInspector);
                }
                sb.append("}");
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> structFields = soi.getAllStructFieldRefs();
                if (o == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                for (int i = 0; i < structFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerDe.appendWithQuotes(sb, structFields.get(i).getFieldName());
                    sb.append(':');
                    JsonSerDe.buildJSONString(sb, soi.getStructFieldData(o, structFields.get(i)), structFields.get(i).getFieldObjectInspector());
                }
                sb.append("}");
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                if (o == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                sb.append(uoi.getTag(o));
                sb.append(':');
                JsonSerDe.buildJSONString(sb, uoi.getField(o), uoi.getObjectInspectors().get(uoi.getTag(o)));
                sb.append("}");
                break;
            }
            default: {
                throw new RuntimeException("Unknown type in ObjectInspector!");
            }
        }
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }
}

