/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class BooleanValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public BooleanValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        if (v1 != null && v2 != null) {
            boolean b2;
            boolean b1 = PrimitiveObjectInspectorUtils.getBoolean(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return Boolean.compare(b1, b2 = PrimitiveObjectInspectorUtils.getBoolean(v2, (PrimitiveObjectInspector)this.expressionDef.getOI())) > 0;
        }
        return false;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        if (v1 != null & v2 != null) {
            boolean b2;
            boolean b1 = PrimitiveObjectInspectorUtils.getBoolean(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return b1 == (b2 = PrimitiveObjectInspectorUtils.getBoolean(v2, (PrimitiveObjectInspector)this.expressionDef.getOI()));
        }
        return v1 == null && v2 == null;
    }
}

