/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.ResolverStyle;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.udf.generic.InstantDateTimeFormatter;
import org.apache.hadoop.hive.ql.udf.generic.InstantSimpleDateFormatter;

public interface InstantFormatter {
    public static InstantFormatter ofConfiguration(Configuration conf) {
        ZoneId zoneId = TimestampTZUtil.parseTimeZone(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE));
        Type type = Type.valueOf(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_DATETIME_FORMATTER).toUpperCase());
        ResolverStyle resolverStyle = ResolverStyle.valueOf(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_DATETIME_RESOLVER_STYLE).toUpperCase());
        return type.newFormatter(zoneId, resolverStyle);
    }

    public Instant parse(String var1) throws RuntimeException;

    public Instant parse(String var1, String var2) throws RuntimeException;

    public String format(Instant var1);

    public String format(Instant var1, String var2);

    public static enum Type {
        SIMPLE{

            @Override
            InstantFormatter newFormatter(ZoneId zone, ResolverStyle resolverStyle) {
                return new InstantSimpleDateFormatter(zone);
            }
        }
        ,
        DATETIME{

            @Override
            InstantFormatter newFormatter(ZoneId zone, ResolverStyle resolverStyle) {
                return new InstantDateTimeFormatter(zone, resolverStyle);
            }
        };


        abstract InstantFormatter newFormatter(ZoneId var1, ResolverStyle var2);
    }
}

