/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="deserialize", value="_FUNC_(base64 encoded message, compressionFormat) - Returns plain text string of given message which was compressed in compressionFormat and base64 encoded.", extended="Currently, Supports only 'gzip' for Gzip compressed and base 64 encoded strings.\nExample:\n  > SELECT _FUNC_('H4sIAAAAAAAA/ytJLS4BAAx+f9gEAAAA', 'gzip') FROM src LIMIT 1;\n  test")
public class GenericUDFDeserialize
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    private static final String FUNC_NAME = "deserialize";
    private transient PrimitiveObjectInspector stringOI = null;
    private transient PrimitiveObjectInspector compressionFormat = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException("The function deserialize accepts 2 arguments.");
        }
        for (ObjectInspector arg : arguments) {
            if (arg.getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP == PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveObjectInspector)arg).getPrimitiveCategory())) continue;
            throw new UDFArgumentTypeException(0, "The arguments to deserialize must be a string/varchar");
        }
        this.stringOI = (PrimitiveObjectInspector)arguments[0];
        this.compressionFormat = (PrimitiveObjectInspector)arguments[1];
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        MessageEncoder encoder;
        String value = PrimitiveObjectInspectorUtils.getString(arguments[0].get(), this.stringOI);
        String compressionFormat = PrimitiveObjectInspectorUtils.getString(arguments[1].get(), this.compressionFormat);
        try {
            encoder = MessageFactory.getInstance((String)compressionFormat);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return encoder.getDeserializer().deSerializeGenericString(value);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return this.getStandardDisplayString(FUNC_NAME, children, ",");
    }
}

