/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFSumDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFSumDecimal64;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFSumDecimal64ToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFSumTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumLong;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.BasePartitionEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="sum", value="_FUNC_(x) - Returns the sum of a set of numbers")
public class GenericUDAFSum
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFSum.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new GenericUDAFSumLong();
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new GenericUDAFSumDouble();
            }
            case DECIMAL: {
                return new GenericUDAFSumHiveDecimal();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        TypeInfo[] parameters = info.getParameters();
        GenericUDAFSumEvaluator eval = (GenericUDAFSumEvaluator)this.getEvaluator(parameters);
        eval.setWindowing(info.isWindowing());
        eval.setSumDistinct(info.isDistinct());
        return eval;
    }

    public static PrimitiveObjectInspector.PrimitiveCategory getReturnType(TypeInfo type) {
        if (type.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        switch (((PrimitiveTypeInfo)type).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return PrimitiveObjectInspector.PrimitiveCategory.LONG;
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return PrimitiveObjectInspector.PrimitiveCategory.DOUBLE;
            }
            case DECIMAL: {
                return PrimitiveObjectInspector.PrimitiveCategory.DECIMAL;
            }
        }
        return null;
    }

    @VectorizedUDAFs(value={VectorUDAFSumLong.class})
    public static class GenericUDAFSumLong
    extends GenericUDAFSumEvaluator<LongWritable> {
        private boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new LongWritable(0L);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            this.outputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumLongAgg result = new SumLongAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumLongAgg myagg = (SumLongAgg)agg;
            myagg.sum = 0L;
            myagg.uniqueObjects = null;
            myagg.nonNullCount = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                try {
                    if (this.isEligibleValue((SumLongAgg)agg, parameters[0])) {
                        ++((SumLongAgg)agg).nonNullCount;
                        SumLongAgg sumLongAgg = (SumLongAgg)agg;
                        sumLongAgg.sum = (Long)sumLongAgg.sum + PrimitiveObjectInspectorUtils.getLong(parameters[0], this.inputOI);
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block4;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                }
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumLongAgg myagg = (SumLongAgg)agg;
                if (this.isWindowingDistinct()) {
                    throw new HiveException("Distinct windowing UDAF doesn't support merge and terminatePartial");
                }
                SumLongAgg sumLongAgg = myagg;
                sumLongAgg.sum = (Long)sumLongAgg.sum + PrimitiveObjectInspectorUtils.getLong(partial, this.inputOI);
                ++myagg.nonNullCount;
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumLongAgg myagg = (SumLongAgg)agg;
            if (myagg.nonNullCount == 0L) {
                return null;
            }
            ((LongWritable)this.result).set(((Long)myagg.sum).longValue());
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            if (this.isWindowingDistinct()) {
                return null;
            }
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<LongWritable, Object[]>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected LongWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumLongAgg myagg = (SumLongAgg)ss.wrappedBuf;
                    long nonNullCount = myagg.nonNullCount;
                    Long r = nonNullCount == 0L ? null : (Long)myagg.sum;
                    Object[] o = (Object[])ss.retrieveNextIntermediateValue();
                    if (o != null) {
                        Long d = (Long)o[0];
                        r = r == null ? null : Long.valueOf(r - d);
                        nonNullCount -= ((Long)o[1]).longValue();
                    }
                    return nonNullCount == 0L ? null : new LongWritable(r.longValue());
                }

                @Override
                protected Object[] getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] objectArray;
                    SumLongAgg myagg = (SumLongAgg)ss.wrappedBuf;
                    if (myagg.nonNullCount == 0L) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = new Long((Long)myagg.sum);
                        objectArray = objectArray2;
                        objectArray2[1] = myagg.nonNullCount;
                    }
                    return objectArray;
                }
            };
        }

        @Override
        protected BasePartitionEvaluator createPartitionEvaluator(WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI, boolean nullsLast) {
            return new BasePartitionEvaluator.SumPartitionLongEvaluator(this, winFrame, partition, parameters, outputOI, nullsLast);
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class SumLongAgg
        extends GenericUDAFSumEvaluator.SumAgg<Long> {
            SumLongAgg() {
            }

            @Override
            public int estimate() {
                return 12;
            }
        }
    }

    @VectorizedUDAFs(value={VectorUDAFSumDouble.class, VectorUDAFSumTimestamp.class})
    public static class GenericUDAFSumDouble
    extends GenericUDAFSumEvaluator<DoubleWritable> {
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new DoubleWritable(0.0);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            this.outputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumDoubleAgg result = new SumDoubleAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumDoubleAgg myagg = (SumDoubleAgg)agg;
            myagg.sum = 0.0;
            myagg.uniqueObjects = null;
            myagg.nonNullCount = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                try {
                    if (this.isEligibleValue((SumDoubleAgg)agg, parameters[0])) {
                        ++((SumDoubleAgg)agg).nonNullCount;
                        SumDoubleAgg sumDoubleAgg = (SumDoubleAgg)agg;
                        sumDoubleAgg.sum = (Double)sumDoubleAgg.sum + PrimitiveObjectInspectorUtils.getDouble(parameters[0], this.inputOI);
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block4;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                    LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                }
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumDoubleAgg myagg = (SumDoubleAgg)agg;
                if (this.isWindowingDistinct()) {
                    throw new HiveException("Distinct windowing UDAF doesn't support merge and terminatePartial");
                }
                SumDoubleAgg sumDoubleAgg = myagg;
                sumDoubleAgg.sum = (Double)sumDoubleAgg.sum + PrimitiveObjectInspectorUtils.getDouble(partial, this.inputOI);
                ++myagg.nonNullCount;
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumDoubleAgg myagg = (SumDoubleAgg)agg;
            if (myagg.nonNullCount == 0L) {
                return null;
            }
            ((DoubleWritable)this.result).set((Double)myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            if (this.sumDistinct) {
                return null;
            }
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<DoubleWritable, Object[]>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected DoubleWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumDoubleAgg myagg = (SumDoubleAgg)ss.wrappedBuf;
                    long nonNullCount = myagg.nonNullCount;
                    Double r = nonNullCount == 0L ? null : (Double)myagg.sum;
                    Object[] o = (Object[])ss.retrieveNextIntermediateValue();
                    if (o != null) {
                        Double d = (Double)o[0];
                        r = r == null ? null : Double.valueOf(r - d);
                        nonNullCount -= ((Long)o[1]).longValue();
                    }
                    return nonNullCount == 0L ? null : new DoubleWritable(r);
                }

                @Override
                protected Object[] getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] objectArray;
                    SumDoubleAgg myagg = (SumDoubleAgg)ss.wrappedBuf;
                    if (myagg.nonNullCount == 0L) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = new Double((Double)myagg.sum);
                        objectArray = objectArray2;
                        objectArray2[1] = myagg.nonNullCount;
                    }
                    return objectArray;
                }
            };
        }

        @Override
        protected BasePartitionEvaluator createPartitionEvaluator(WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI, boolean nullsLast) {
            return new BasePartitionEvaluator.SumPartitionDoubleEvaluator(this, winFrame, partition, parameters, outputOI, nullsLast);
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class SumDoubleAgg
        extends GenericUDAFSumEvaluator.SumAgg<Double> {
            SumDoubleAgg() {
            }

            @Override
            public int estimate() {
                return 12;
            }
        }
    }

    @VectorizedUDAFs(value={VectorUDAFSumDecimal.class, VectorUDAFSumDecimal64.class, VectorUDAFSumDecimal64ToDecimal.class})
    public static class GenericUDAFSumHiveDecimal
    extends GenericUDAFSumEvaluator<HiveDecimalWritable> {
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.result = new HiveDecimalWritable(0L);
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            DecimalTypeInfo outputTypeInfo = this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE ? GenericUDAFSumHiveDecimal.getOutputDecimalTypeInfoForSum(this.inputOI.precision(), this.inputOI.scale(), this.mode) : (DecimalTypeInfo)this.inputOI.getTypeInfo();
            AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(outputTypeInfo);
            this.outputOI = (PrimitiveObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(oi, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return oi;
        }

        public static DecimalTypeInfo getOutputDecimalTypeInfoForSum(int inputPrecision, int inputScale, GenericUDAFEvaluator.Mode mode) {
            DecimalTypeInfo outputTypeInfo = null;
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                int precision = Math.min(38, inputPrecision + 10);
                outputTypeInfo = TypeInfoFactory.getDecimalTypeInfo(precision, inputScale);
            } else {
                outputTypeInfo = TypeInfoFactory.getDecimalTypeInfo(inputPrecision, inputScale);
            }
            return outputTypeInfo;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            SumHiveDecimalWritableAgg agg = new SumHiveDecimalWritableAgg();
            this.reset(agg);
            return agg;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFSumEvaluator.SumAgg bdAgg = (GenericUDAFSumEvaluator.SumAgg)agg;
            bdAgg.sum = new HiveDecimalWritable(0L);
            bdAgg.uniqueObjects = null;
            bdAgg.nonNullCount = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                try {
                    if (this.isEligibleValue((SumHiveDecimalWritableAgg)agg, parameters[0])) {
                        ++((SumHiveDecimalWritableAgg)agg).nonNullCount;
                        ((HiveDecimalWritable)((SumHiveDecimalWritableAgg)agg).sum).mutateAdd(PrimitiveObjectInspectorUtils.getHiveDecimal(parameters[0], this.inputOI));
                    }
                }
                catch (NumberFormatException e) {
                    if (this.warned) break block4;
                    this.warned = true;
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                    LOG.warn(this.getClass().getSimpleName() + " ignoring similar exceptions.");
                }
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)agg;
                if (myagg.sum == null || !((HiveDecimalWritable)myagg.sum).isSet()) {
                    return;
                }
                if (this.isWindowingDistinct()) {
                    throw new HiveException("Distinct windowing UDAF doesn't support merge and terminatePartial");
                }
                ((HiveDecimalWritable)myagg.sum).mutateAdd(PrimitiveObjectInspectorUtils.getHiveDecimal(partial, this.inputOI));
                ++myagg.nonNullCount;
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)agg;
            if (myagg.nonNullCount == 0L || myagg.sum == null || !((HiveDecimalWritable)myagg.sum).isSet()) {
                return null;
            }
            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.outputOI.getTypeInfo();
            ((HiveDecimalWritable)myagg.sum).mutateEnforcePrecisionScale(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
            if (!((HiveDecimalWritable)myagg.sum).isSet()) {
                LOG.warn("The sum of a column with data type HiveDecimal is out of range");
                return null;
            }
            ((HiveDecimalWritable)this.result).set((HiveDecimalWritable)myagg.sum);
            return this.result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrameDef) {
            if (this.sumDistinct) {
                return null;
            }
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<HiveDecimalWritable, Object[]>((GenericUDAFEvaluator)this, wFrameDef){

                @Override
                protected HiveDecimalWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)ss.wrappedBuf;
                    long nonNullCount = myagg.nonNullCount;
                    HiveDecimal r = nonNullCount == 0L ? null : ((HiveDecimalWritable)myagg.sum).getHiveDecimal();
                    Object[] o = (Object[])ss.retrieveNextIntermediateValue();
                    if (o != null) {
                        HiveDecimal d = (HiveDecimal)o[0];
                        r = r == null ? null : r.subtract(d);
                        nonNullCount -= ((Long)o[1]).longValue();
                    }
                    return nonNullCount == 0L ? null : new HiveDecimalWritable(r);
                }

                @Override
                protected Object[] getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] objectArray;
                    SumHiveDecimalWritableAgg myagg = (SumHiveDecimalWritableAgg)ss.wrappedBuf;
                    if (myagg.nonNullCount == 0L) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = ((HiveDecimalWritable)myagg.sum).getHiveDecimal();
                        objectArray = objectArray2;
                        objectArray2[1] = myagg.nonNullCount;
                    }
                    return objectArray;
                }
            };
        }

        @Override
        protected BasePartitionEvaluator createPartitionEvaluator(WindowFrameDef winFrame, PTFPartition partition, List<PTFExpressionDef> parameters, ObjectInspector outputOI, boolean nullsLast) {
            return new BasePartitionEvaluator.SumPartitionHiveDecimalEvaluator(this, winFrame, partition, parameters, outputOI, nullsLast);
        }

        @GenericUDAFEvaluator.AggregationType(estimable=false)
        static class SumHiveDecimalWritableAgg
        extends GenericUDAFSumEvaluator.SumAgg<HiveDecimalWritable> {
            SumHiveDecimalWritableAgg() {
            }
        }
    }

    public static abstract class GenericUDAFSumEvaluator<ResultType extends Writable>
    extends GenericUDAFEvaluator {
        protected PrimitiveObjectInspector inputOI;
        protected PrimitiveObjectInspector outputOI;
        protected ResultType result;
        protected boolean isWindowing;
        protected boolean sumDistinct;

        public void setWindowing(boolean isWindowing) {
            this.isWindowing = isWindowing;
        }

        public void setSumDistinct(boolean sumDistinct) {
            this.sumDistinct = sumDistinct;
        }

        public boolean isWindowingDistinct() {
            return this.isWindowing && this.sumDistinct;
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            if (this.isWindowingDistinct()) {
                throw new HiveException("Distinct windowing UDAF doesn't support merge and terminatePartial");
            }
            return this.terminate(agg);
        }

        protected boolean isEligibleValue(SumAgg agg, Object input) {
            if (input == null) {
                return false;
            }
            if (this.isWindowingDistinct()) {
                ObjectInspectorUtils.ObjectInspectorObject obj;
                if (agg.uniqueObjects == null) {
                    agg.uniqueObjects = new HashSet();
                }
                HashSet<ObjectInspectorUtils.ObjectInspectorObject> uniqueObjs = agg.uniqueObjects;
                ObjectInspectorUtils.ObjectInspectorObject objectInspectorObject = obj = input instanceof ObjectInspectorUtils.ObjectInspectorObject ? (ObjectInspectorUtils.ObjectInspectorObject)input : new ObjectInspectorUtils.ObjectInspectorObject(ObjectInspectorUtils.copyToStandardObject(input, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA), this.outputOI);
                if (!uniqueObjs.contains(obj)) {
                    uniqueObjs.add(obj);
                    return true;
                }
                return false;
            }
            return true;
        }

        static abstract class SumAgg<T>
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            T sum;
            HashSet<ObjectInspectorUtils.ObjectInspectorObject> uniqueObjects;
            long nonNullCount;

            SumAgg() {
            }
        }
    }
}

