/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileCont;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="percentile_disc", value="_FUNC_(input, pc) - Returns the percentile of expr at pc (range: [0,1]) without interpolation.")
@WindowFunctionDescription(supportsWindow=false, pivotResult=true, orderedAggregate=true)
public class GenericUDAFPercentileDisc
extends GenericUDAFPercentileCont {
    @Override
    protected GenericUDAFEvaluator createLongEvaluator(TypeInfo percentile) {
        return percentile.getCategory() == ObjectInspector.Category.LIST ? new PercentileDiscLongArrayEvaluator() : new PercentileDiscLongEvaluator();
    }

    @Override
    protected GenericUDAFEvaluator createDoubleEvaluator(TypeInfo percentile) {
        return percentile.getCategory() == ObjectInspector.Category.LIST ? new PercentileDiscDoubleArrayEvaluator() : new PercentileDiscDoubleEvaluator();
    }

    public static class PercentileDiscDoubleCalculator
    implements GenericUDAFPercentileCont.PercentileCalculator<DoubleWritable> {
        @Override
        public double getPercentile(List<Map.Entry<DoubleWritable, LongWritable>> entriesList, double position) {
            long lower = (long)Math.floor(position);
            long higher = (long)Math.ceil(position);
            int i = 0;
            while (entriesList.get(i).getValue().get() < lower + 1L) {
                ++i;
            }
            double lowerKey = entriesList.get(i).getKey().get();
            if (higher == lower) {
                return lowerKey;
            }
            if (entriesList.get(i).getValue().get() < higher + 1L) {
                ++i;
            }
            return entriesList.get(i).getKey().get();
        }
    }

    public static class PercentileDiscLongCalculator
    implements GenericUDAFPercentileCont.PercentileCalculator<LongWritable> {
        @Override
        public double getPercentile(List<Map.Entry<LongWritable, LongWritable>> entriesList, double position) {
            long lower = (long)Math.floor(position);
            long higher = (long)Math.ceil(position);
            int i = 0;
            while (entriesList.get(i).getValue().get() < lower + 1L) {
                ++i;
            }
            long lowerKey = entriesList.get(i).getKey().get();
            if (higher == lower) {
                return lowerKey;
            }
            if (entriesList.get(i).getValue().get() < higher + 1L) {
                ++i;
            }
            return entriesList.get(i).getKey().get();
        }
    }

    public static class PercentileDiscDoubleArrayEvaluator
    extends GenericUDAFPercentileCont.PercentileContDoubleArrayEvaluator {
        @Override
        protected GenericUDAFPercentileCont.PercentileCalculator<DoubleWritable> getCalculator() {
            return new PercentileDiscDoubleCalculator();
        }
    }

    public static class PercentileDiscDoubleEvaluator
    extends GenericUDAFPercentileCont.PercentileContDoubleEvaluator {
        @Override
        protected GenericUDAFPercentileCont.PercentileCalculator<DoubleWritable> getCalculator() {
            return new PercentileDiscDoubleCalculator();
        }
    }

    public static class PercentileDiscLongArrayEvaluator
    extends GenericUDAFPercentileCont.PercentileContLongArrayEvaluator {
        @Override
        protected GenericUDAFPercentileCont.PercentileCalculator<LongWritable> getCalculator() {
            return new PercentileDiscLongCalculator();
        }
    }

    public static class PercentileDiscLongEvaluator
    extends GenericUDAFPercentileCont.PercentileContLongEvaluator {
        @Override
        protected GenericUDAFPercentileCont.PercentileCalculator<LongWritable> getCalculator() {
            return new PercentileDiscLongCalculator();
        }
    }
}

