/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_PointFromWKB", value="_FUNC_(wkb) - construct an ST_Point from OGC well-known binary", extended="Example:\n  SELECT _FUNC_(ST_AsBinary(ST_GeomFromText('point (1 0))'))) FROM src LIMIT 1;  -- constructs ST_Point\n")
public class ST_PointFromWKB
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_PointFromWKB.class.getName());

    public BytesWritable evaluate(BytesWritable wkb) throws UDFArgumentException {
        return this.evaluate(wkb, 0);
    }

    public BytesWritable evaluate(BytesWritable wkb, int wkid) throws UDFArgumentException {
        try {
            SpatialReference spatialReference = null;
            if (wkid != 0) {
                spatialReference = SpatialReference.create(wkid);
            }
            byte[] byteArr = wkb.getBytes();
            ByteBuffer byteBuf = ByteBuffer.allocate(byteArr.length);
            byteBuf.put(byteArr);
            OGCGeometry ogcObj = OGCGeometry.fromBinary(byteBuf);
            ogcObj.setSpatialReference(spatialReference);
            if (ogcObj.geometryType().equals("Point")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_POINT, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }
}

