/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_MultiPolygon", value="_FUNC_(array(x1, y1, x2, y2, ... ), array(x1, y1, x2, y2, ... ), ... ) - constructor for 2D multi polygon\n_FUNC_('multipolygon ( ... )') - constructor for 2D multi polygon", extended="Example:\n  SELECT _FUNC_(array(1, 1, 1, 2, 2, 2, 2, 1), array(3, 3, 3, 4, 4, 4, 4, 3)) from src LIMIT 1;\n  SELECT _FUNC_('multipolygon (((0 0, 0 1, 1 0, 0 0)), ((2 2, 2 3, 3 2, 2 2)))') from src LIMIT 1;")
public class ST_MultiPolygon
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_MultiPolygon.class.getName());

    public BytesWritable evaluate(List<DoubleWritable> ... multipaths) throws UDFArgumentLengthException {
        if (multipaths == null || multipaths.length == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            String wkt = "multipolygon(";
            int arg_idx = 0;
            String comma = "";
            for (List<DoubleWritable> multipath : multipaths) {
                int ix;
                int len = multipath.size();
                if (len < 6 || len % 2 != 0) {
                    LogUtils.Log_VariableArgumentLengthXY(LOG, arg_idx);
                    return null;
                }
                double xStart = multipath.get(0).get();
                double yStart = multipath.get(1).get();
                wkt = wkt + comma + "((" + xStart + " " + yStart;
                for (ix = 2; ix < len; ix += 2) {
                    wkt = wkt + ", " + (Object)((Object)multipath.get(ix)) + " " + (Object)((Object)multipath.get(ix + 1));
                }
                double xEnd = multipath.get(ix - 2).get();
                double yEnd = multipath.get(ix - 1).get();
                if (xEnd != xStart || yEnd != yStart) {
                    wkt = wkt + ", " + xStart + " " + yStart;
                }
                wkt = wkt + "))";
                comma = ",";
                ++arg_idx;
            }
            wkt = wkt + ")";
            return this.evaluate(new Text(wkt));
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_MultiPolygon: " + e);
            return null;
        }
    }

    public BytesWritable evaluate(Text wkwrap) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            OGCGeometry ogcObj = OGCGeometry.fromText(wkt);
            ogcObj.setSpatialReference(null);
            if (ogcObj.geometryType().equals("MultiPolygon")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_MULTIPOLYGON, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

