/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_GeomFromShape", value="_FUNC_(shape) - construct ST_Geometry from Esri shape representation of geometry\n", extended="Example:\n  SELECT _FUNC_(ST_AsShape(ST_Point(1, 2))); -- constructs ST_Point\n")
public class ST_GeomFromShape
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_GeomFromShape.class.getName());

    public BytesWritable evaluate(BytesWritable shape) throws UDFArgumentException {
        return this.evaluate(shape, 0);
    }

    public BytesWritable evaluate(BytesWritable shape, int wkid) throws UDFArgumentException {
        try {
            Geometry geometry = GeometryEngine.geometryFromEsriShape(shape.getBytes(), Geometry.Type.Unknown);
            switch (geometry.getType()) {
                case Point: {
                    return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.ST_POINT);
                }
                case MultiPoint: {
                    return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.ST_MULTIPOINT);
                }
                case Line: {
                    return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.ST_LINESTRING);
                }
                case Polyline: {
                    return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.ST_MULTILINESTRING);
                }
                case Envelope: {
                    return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.ST_POLYGON);
                }
                case Polygon: {
                    return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.ST_MULTIPOLYGON);
                }
            }
            return GeometryUtils.geometryToEsriShapeBytesWritable(geometry, wkid, GeometryUtils.OGCType.UNKNOWN);
        }
        catch (Exception e) {
            LogUtils.Log_ExceptionThrown(LOG, "geom-from-shape", e);
            return null;
        }
    }
}

