/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_GeomCollection", value="_FUNC_(wkt) - construct a multi-part ST_Geometry from OGC well-known text", extended="Example:\n  > SELECT _FUNC_('multipoint ((1 0), (2 3))') FROM src LIMIT 1;  -- constructs ST_MultiPoint\nOGC Compliance Notes : \n ST_GeomCollection on Hive does not support collections - only multi-part geometries.\nST_GeomCollection('POINT(1 1), LINESTRING(2 0,3 0)') -- not supported\n")
public class ST_GeomCollection
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_GeomCollection.class.getName());

    public BytesWritable evaluate(Text wkt) throws UDFArgumentException {
        return this.evaluate(wkt, 0);
    }

    public BytesWritable evaluate(Text wkwrap, int wkid) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            Geometry geomObj = GeometryEngine.geometryFromWkt(wkt, 0, Geometry.Type.Unknown);
            SpatialReference spatialReference = null;
            if (wkid != 0) {
                spatialReference = SpatialReference.create(wkid);
            }
            OGCGeometry ogcObj = OGCGeometry.createFromEsriGeometry(geomObj, spatialReference);
            return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

