/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_AsText", value="_FUNC_(ST_Geometry) - return Well-Known Text (WKT) representation of ST_Geometry\n", extended="Example:\n  SELECT _FUNC_(ST_Point(1, 2)) FROM onerow;  --  POINT (1 2)\n")
public class ST_AsText
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_AsText.class.getName());

    public Text evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        int wktExportFlag = this.getWktExportFlag(GeometryUtils.getType(geomref));
        try {
            return new Text(GeometryEngine.geometryToWkt(ogcGeometry.getEsriGeometry(), wktExportFlag));
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    private int getWktExportFlag(GeometryUtils.OGCType type) {
        switch (type) {
            case ST_POLYGON: {
                return 16;
            }
            case ST_MULTIPOLYGON: {
                return 32;
            }
            case ST_POINT: {
                return 1;
            }
            case ST_MULTIPOINT: {
                return 2;
            }
            case ST_LINESTRING: {
                return 4;
            }
            case ST_MULTILINESTRING: {
                return 8;
            }
        }
        return 0;
    }
}

