/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import hiveexec.com.google.common.collect.ImmutableMap;
import hiveexec.com.google.common.collect.ImmutableSet;
import hiveexec.com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@InterfaceAudience.Private
public enum VirtualColumn {
    FILENAME("INPUT__FILE__NAME", TypeInfoFactory.stringTypeInfo),
    BLOCKOFFSET("BLOCK__OFFSET__INSIDE__FILE", TypeInfoFactory.longTypeInfo),
    ROWOFFSET("ROW__OFFSET__INSIDE__BLOCK", TypeInfoFactory.longTypeInfo),
    RAWDATASIZE("RAW__DATA__SIZE", TypeInfoFactory.longTypeInfo),
    ROWID("ROW__ID", RecordIdentifier.StructInfo.typeInfo, true, RecordIdentifier.StructInfo.oi),
    ROWISDELETED("ROW__IS__DELETED", TypeInfoFactory.booleanTypeInfo),
    PARTITION_SPEC_ID("PARTITION__SPEC__ID", TypeInfoFactory.intTypeInfo),
    PARTITION_HASH("PARTITION__HASH", TypeInfoFactory.longTypeInfo),
    FILE_PATH("FILE__PATH", TypeInfoFactory.stringTypeInfo),
    ROW_POSITION("ROW__POSITION", TypeInfoFactory.longTypeInfo),
    SNAPSHOT_ID("SNAPSHOT__ID", TypeInfoFactory.longTypeInfo),
    GROUPINGID("GROUPING__ID", TypeInfoFactory.longTypeInfo);

    public static final ImmutableSet<String> VIRTUAL_COLUMN_NAMES;
    public static final ImmutableMap<String, VirtualColumn> VIRTUAL_COLUMN_NAME_MAP;
    private final String name;
    private final TypeInfo typeInfo;
    private final boolean isHidden;
    private final ObjectInspector oi;

    private static Map<String, VirtualColumn> getColumnNameMap() {
        HashMap<String, VirtualColumn> map = new HashMap<String, VirtualColumn>();
        for (VirtualColumn virtualColumn : VirtualColumn.values()) {
            map.put(virtualColumn.name, virtualColumn);
        }
        return map;
    }

    private VirtualColumn(String name, PrimitiveTypeInfo typeInfo) {
        this(name, typeInfo, true, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(typeInfo));
    }

    private VirtualColumn(String name, TypeInfo typeInfo, boolean isHidden, ObjectInspector oi) {
        this.name = name;
        this.typeInfo = typeInfo;
        this.isHidden = isHidden;
        this.oi = oi;
    }

    public static List<VirtualColumn> getStatsRegistry(Configuration conf) {
        ArrayList<VirtualColumn> l = new ArrayList<VirtualColumn>();
        l.add(RAWDATASIZE);
        return l;
    }

    public static List<VirtualColumn> getRegistry(HiveConf conf) {
        ArrayList<VirtualColumn> l = new ArrayList<VirtualColumn>();
        if (conf.getFunctionResolverEngine().equals((Object)HiveConf.Engine.IMPALA)) {
            return l;
        }
        switch (conf.getEngine()) {
            case HIVE: {
                l.add(BLOCKOFFSET);
                l.add(FILENAME);
                if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEROWOFFSET)) {
                    l.add(ROWOFFSET);
                }
                l.add(ROWID);
                l.add(ROWISDELETED);
                break;
            }
            case IMPALA: {
                break;
            }
        }
        return l;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public ObjectInspector getObjectInspector() {
        return this.oi;
    }

    public static Collection<String> removeVirtualColumns(Collection<String> columns) {
        Iterables.removeAll(columns, VIRTUAL_COLUMN_NAMES);
        return columns;
    }

    public static List<TypeInfo> removeVirtualColumnTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("Number of column names in configuration " + columnNames.size() + " differs from column types " + columnTypes.size());
        }
        int i = 0;
        ListIterator<TypeInfo> it = columnTypes.listIterator();
        while (it.hasNext()) {
            it.next();
            if (VIRTUAL_COLUMN_NAMES.contains(columnNames.get(i))) {
                it.remove();
            }
            ++i;
        }
        return columnTypes;
    }

    public static StructObjectInspector getVCSObjectInspector(List<VirtualColumn> vcs) {
        ArrayList<String> names = new ArrayList<String>(vcs.size());
        ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(vcs.size());
        for (VirtualColumn vc : vcs) {
            names.add(vc.getName());
            inspectors.add(vc.oi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
    }

    public static boolean isVirtualColumnBasedOnAlias(ColumnInfo column) {
        return column.getAlias() != null && VIRTUAL_COLUMN_NAMES.contains(column.getAlias().toUpperCase());
    }

    static {
        VIRTUAL_COLUMN_NAMES = ImmutableSet.of(FILENAME.getName(), BLOCKOFFSET.getName(), ROWOFFSET.getName(), RAWDATASIZE.getName(), GROUPINGID.getName(), ROWID.getName(), new String[]{ROWISDELETED.getName(), PARTITION_SPEC_ID.getName(), PARTITION_HASH.getName(), FILE_PATH.getName(), ROW_POSITION.getName()});
        VIRTUAL_COLUMN_NAME_MAP = new ImmutableMap.Builder<String, VirtualColumn>().putAll(VirtualColumn.getColumnNameMap()).build();
    }
}

