/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewsCache {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewsCache.class);
    private final ConcurrentMap<String, ConcurrentMap<String, HiveRelOptMaterialization>> materializedViews = new ConcurrentHashMap<String, ConcurrentMap<String, HiveRelOptMaterialization>>();
    private final Map<ASTKey, List<HiveRelOptMaterialization>> sqlToMaterializedView = new ConcurrentHashMap<ASTKey, List<HiveRelOptMaterialization>>();

    public void putIfAbsent(Table materializedViewTable, HiveRelOptMaterialization materialization) {
        ConcurrentMap<String, HiveRelOptMaterialization> dbMap = this.ensureDbMap(materializedViewTable);
        dbMap.computeIfAbsent(materializedViewTable.getTableName(), mvTableName -> {
            List materializationList = this.sqlToMaterializedView.computeIfAbsent(new ASTKey(materialization.getAst()), s -> new ArrayList());
            materializationList.add(materialization);
            return materialization;
        });
        LOG.debug("Materialized view {}.{} added to registry", (Object)materializedViewTable.getDbName(), (Object)materializedViewTable.getTableName());
    }

    private ConcurrentMap<String, HiveRelOptMaterialization> ensureDbMap(Table materializedViewTable) {
        ConcurrentMap<String, HiveRelOptMaterialization> dbMap = new ConcurrentHashMap<String, HiveRelOptMaterialization>();
        ConcurrentMap prevDbMap = this.materializedViews.putIfAbsent(materializedViewTable.getDbName(), dbMap);
        if (prevDbMap != null) {
            dbMap = prevDbMap;
        }
        return dbMap;
    }

    public void refresh(Table oldMaterializedViewTable, Table materializedViewTable, HiveRelOptMaterialization newMaterialization) {
        ConcurrentMap<String, HiveRelOptMaterialization> dbMap = this.ensureDbMap(materializedViewTable);
        dbMap.compute(materializedViewTable.getTableName(), (mvTableName, existingMaterialization) -> {
            List optMaterializationList = this.sqlToMaterializedView.computeIfAbsent(new ASTKey(newMaterialization.getAst()), s -> new ArrayList());
            if (existingMaterialization == null) {
                optMaterializationList.add(newMaterialization);
                return newMaterialization;
            }
            Table existingMaterializedViewTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)existingMaterialization);
            if (existingMaterializedViewTable.equals(oldMaterializedViewTable)) {
                optMaterializationList.remove(existingMaterialization);
                optMaterializationList.add(newMaterialization);
                return newMaterialization;
            }
            return existingMaterialization;
        });
        if (LOG.isDebugEnabled()) {
            String oldViewName = oldMaterializedViewTable == null ? "" : String.format("%s.%s -> ", oldMaterializedViewTable.getDbName(), oldMaterializedViewTable.getTableName());
            LOG.debug("Refreshed materialized view {}{}.{}", new Object[]{oldViewName, materializedViewTable.getDbName(), materializedViewTable.getTableName()});
        }
    }

    public void remove(Table materializedViewTable) {
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(materializedViewTable.getDbName());
        if (dbMap != null) {
            dbMap.computeIfPresent(materializedViewTable.getTableName(), (mvTableName, oldMaterialization) -> {
                Table oldTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)oldMaterialization);
                if (materializedViewTable.equals(oldTable)) {
                    this.remove((HiveRelOptMaterialization)((Object)oldMaterialization), oldTable);
                    return null;
                }
                return oldMaterialization;
            });
            if (dbMap.isEmpty()) {
                this.materializedViews.remove(materializedViewTable.getDbName());
            }
        }
        LOG.debug("Materialized view {}.{} removed from registry", (Object)materializedViewTable.getDbName(), (Object)materializedViewTable.getTableName());
    }

    private void remove(HiveRelOptMaterialization materialization, Table mvTable) {
        if (mvTable == null) {
            return;
        }
        ASTKey ASTKey2 = new ASTKey(materialization.getAst());
        List<HiveRelOptMaterialization> materializationList = this.sqlToMaterializedView.get(ASTKey2);
        if (materializationList == null) {
            return;
        }
        materializationList.remove((Object)materialization);
        if (materializationList.isEmpty()) {
            this.sqlToMaterializedView.remove(ASTKey2);
        }
    }

    public void remove(String dbName, String tableName) {
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(dbName);
        if (dbMap != null) {
            dbMap.computeIfPresent(tableName, (mvTableName, materialization) -> {
                this.remove((HiveRelOptMaterialization)((Object)materialization), HiveMaterializedViewUtils.extractTable((RelOptMaterialization)materialization));
                return null;
            });
            if (dbMap.isEmpty()) {
                this.materializedViews.remove(dbName);
            }
            LOG.debug("Materialized view {}.{} removed from registry", (Object)dbName, (Object)tableName);
        }
    }

    public List<HiveRelOptMaterialization> values() {
        ArrayList result = new ArrayList();
        this.materializedViews.forEach((dbName, mvs) -> result.addAll(mvs.values()));
        return Collections.unmodifiableList(result);
    }

    HiveRelOptMaterialization get(String dbName, String viewName) {
        if (this.materializedViews.get(dbName) != null) {
            LOG.debug("Found materialized view {}.{} in registry", (Object)dbName, (Object)viewName);
            return (HiveRelOptMaterialization)((Object)((ConcurrentMap)this.materializedViews.get(dbName)).get(viewName));
        }
        LOG.debug("Materialized view {}.{} not found in registry", (Object)dbName, (Object)viewName);
        return null;
    }

    public List<HiveRelOptMaterialization> get(ASTNode astNode) {
        List<HiveRelOptMaterialization> relOptMaterializationList = this.sqlToMaterializedView.get(new ASTKey(astNode));
        if (relOptMaterializationList == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No materialized view with query text '{}' found in registry.", (Object)astNode.dump());
            }
            LOG.debug("No materialized view with similar query text found in registry.");
            return Collections.emptyList();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} materialized view(s) found with query text '{}' in registry", (Object)relOptMaterializationList.size(), (Object)astNode.dump());
        }
        LOG.debug("{} materialized view(s) found with similar query text found in registry", (Object)relOptMaterializationList.size());
        return Collections.unmodifiableList(relOptMaterializationList);
    }

    public boolean isEmpty() {
        return this.materializedViews.isEmpty();
    }

    private static class ASTKey {
        private final ASTNode root;

        public ASTKey(ASTNode root) {
            this.root = root;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ASTKey that = (ASTKey)o;
            return this.equals(this.root, that.root);
        }

        private boolean equals(ASTNode astNode1, ASTNode astNode2) {
            if (astNode1.getType() != astNode2.getType() || !astNode1.getText().equals(astNode2.getText()) || astNode1.getChildCount() != astNode2.getChildCount()) {
                return false;
            }
            for (int i = 0; i < astNode1.getChildCount(); ++i) {
                if (this.equals((ASTNode)astNode1.getChild(i), (ASTNode)astNode2.getChild(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashcode(this.root);
        }

        private int hashcode(ASTNode node) {
            int result = Objects.hash(node.getType(), node.getText());
            for (int i = 0; i < node.getChildCount(); ++i) {
                result = 31 * result + this.hashcode((ASTNode)node.getChild(i));
            }
            return result;
        }
    }
}

