/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class IfExprDecimalScalarColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private HiveDecimal arg2Scalar;

    public IfExprDecimalScalarColumn(int arg1Column, HiveDecimal arg2Scalar, int arg3Column, int outputColumnNum) {
        super(arg1Column, arg3Column, outputColumnNum);
        this.arg2Scalar = arg2Scalar;
    }

    public IfExprDecimalScalarColumn() {
        this.arg2Scalar = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        DecimalColumnVector arg3ColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum[1]];
        boolean[] arg3IsNull = arg3ColVector.isNull;
        HiveDecimalWritable[] vector3 = arg3ColVector.vector;
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            }
            return;
        }
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, this.arg2Scalar);
                        continue;
                    }
                    if (!arg3IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, vector3[i]);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, this.arg2Scalar);
                        continue;
                    }
                    if (!arg3IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, vector3[i]);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, this.arg2Scalar);
                    continue;
                }
                if (!arg3IsNull[i]) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, vector3[i]);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, this.arg2Scalar);
                    continue;
                }
                if (!arg3IsNull[i]) {
                    outputIsNull[i] = false;
                    outputColVector.set(i, vector3[i]);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + this.arg2Scalar + ", " + this.getColumnParamString(2, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"int_family"), VectorExpressionDescriptor.ArgumentType.getType((String)"decimal"), VectorExpressionDescriptor.ArgumentType.getType((String)"decimal")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

