/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterTimestampColumnBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private Timestamp leftValue;
    private Timestamp rightValue;

    public FilterTimestampColumnBetween(int colNum, Timestamp leftValue, Timestamp rightValue) {
        super(colNum, -1);
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public FilterTimestampColumnBetween() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (inputColVector.compareTo(0, this.leftValue) < 0 || inputColVector.compareTo(0, this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inputColVector.compareTo(this.leftValue, i) > 0 || inputColVector.compareTo(i, this.rightValue) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.compareTo(this.leftValue, i) > 0 || inputColVector.compareTo(i, this.rightValue) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!inputIsNull[0]) {
                if (inputColVector.compareTo(0, this.leftValue) < 0 || inputColVector.compareTo(0, this.rightValue) > 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (inputIsNull[i] || inputColVector.compareTo(this.leftValue, i) > 0 || inputColVector.compareTo(i, this.rightValue) > 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (inputIsNull[i] || inputColVector.compareTo(this.leftValue, i) > 0 || inputColVector.compareTo(i, this.rightValue) > 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    public Timestamp getLeftValue() {
        return this.leftValue;
    }

    public void setLeftValue(Timestamp value) {
        this.leftValue = value;
    }

    public Timestamp getRightValue() {
        return this.rightValue;
    }

    public void setRightValue(Timestamp value) {
        this.rightValue = value;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", left " + this.leftValue.toString() + ", right " + this.rightValue.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"timestamp"), VectorExpressionDescriptor.ArgumentType.getType((String)"timestamp"), VectorExpressionDescriptor.ArgumentType.getType((String)"timestamp")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

